% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_domain}
\alias{sagemaker_create_domain}
\title{Creates a Domain used by SageMaker Studio}
\usage{
sagemaker_create_domain(DomainName, AuthMode, DefaultUserSettings,
  SubnetIds, VpcId, Tags, HomeEfsFileSystemKmsKeyId)
}
\arguments{
\item{DomainName}{[required] A name for the domain.}

\item{AuthMode}{[required] The mode of authentication that members use to access the domain.}

\item{DefaultUserSettings}{[required] The default user settings.}

\item{SubnetIds}{[required] The VPC subnets to use for communication with the EFS volume.}

\item{VpcId}{[required] The ID of the Amazon Virtual Private Cloud (VPC) to use for
communication with the EFS volume.}

\item{Tags}{Tags to associated with the Domain. Each tag consists of a key and an
optional value. Tag keys must be unique per resource. Tags are
searchable using the Search API.}

\item{HomeEfsFileSystemKmsKeyId}{The AWS Key Management Service (KMS) encryption key ID. Encryption with
a customer master key (CMK) is not supported.}
}
\description{
Creates a \code{Domain} used by SageMaker Studio. A domain consists of an
associated directory, a list of authorized users, and a variety of
security, application, policy, and Amazon Virtual Private Cloud (VPC)
configurations. An AWS account is limited to one domain per region.
Users within a domain can share notebook files and other artifacts with
each other.
}
\details{
When a domain is created, an Amazon Elastic File System (EFS) volume is
also created for use by all of the users within the domain. Each user
receives a private home directory within the EFS for notebooks, Git
repositories, and data files.

All traffic between the domain and the EFS volume is communicated
through the specified subnet IDs. All other traffic goes over the
Internet through an Amazon SageMaker system VPC. The EFS traffic uses
the NFS/TCP protocol over port 2049.

NFS traffic over TCP on port 2049 needs to be allowed in both inbound
and outbound rules in order to launch a SageMaker Studio app
successfully.
}
\section{Request syntax}{
\preformatted{svc$create_domain(
  DomainName = "string",
  AuthMode = "SSO"|"IAM",
  DefaultUserSettings = list(
    ExecutionRole = "string",
    SecurityGroups = list(
      "string"
    ),
    SharingSettings = list(
      NotebookOutputOption = "Allowed"|"Disabled",
      S3OutputPath = "string",
      S3KmsKeyId = "string"
    ),
    JupyterServerAppSettings = list(
      DefaultResourceSpec = list(
        SageMakerImageArn = "string",
        InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
      )
    ),
    KernelGatewayAppSettings = list(
      DefaultResourceSpec = list(
        SageMakerImageArn = "string",
        InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
      )
    ),
    TensorBoardAppSettings = list(
      DefaultResourceSpec = list(
        SageMakerImageArn = "string",
        InstanceType = "system"|"ml.t3.micro"|"ml.t3.small"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.8xlarge"|"ml.m5.12xlarge"|"ml.m5.16xlarge"|"ml.m5.24xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.12xlarge"|"ml.c5.18xlarge"|"ml.c5.24xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"
      )
    )
  ),
  SubnetIds = list(
    "string"
  ),
  VpcId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  HomeEfsFileSystemKmsKeyId = "string"
)
}
}

\keyword{internal}
