% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_list_lexicons}
\alias{polly_list_lexicons}
\title{Returns a list of pronunciation lexicons stored in an AWS Region}
\usage{
polly_list_lexicons(NextToken)
}
\arguments{
\item{NextToken}{An opaque pagination token returned from previous
\code{\link[=polly_list_lexicons]{list_lexicons}} operation. If present, indicates
where to continue the list of lexicons.}
}
\value{
A list with the following syntax:\preformatted{list(
  Lexicons = list(
    list(
      Name = "string",
      Attributes = list(
        Alphabet = "string",
        LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR",
        LastModified = as.POSIXct(
          "2015-01-01"
        ),
        LexiconArn = "string",
        LexemesCount = 123,
        Size = 123
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of pronunciation lexicons stored in an AWS Region. For
more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html}{Managing Lexicons}.
}
\section{Request syntax}{
\preformatted{svc$list_lexicons(
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# Returns a list of pronunciation lexicons stored in an AWS Region.
svc$list_lexicons()
}

}
\keyword{internal}
