% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_filters}
\alias{personalize_list_filters}
\title{Lists all filters that belong to a given dataset group}
\usage{
personalize_list_filters(datasetGroupArn, nextToken, maxResults)
}
\arguments{
\item{datasetGroupArn}{The ARN of the dataset group that contains the filters.}

\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_filters]{list_filters}} for getting the next set of
filters (if they exist).}

\item{maxResults}{The maximum number of filters to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Filters = list(
    list(
      name = "string",
      filterArn = "string",
      creationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      datasetGroupArn = "string",
      failureReason = "string",
      status = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists all filters that belong to a given dataset group.
}
\section{Request syntax}{
\preformatted{svc$list_filters(
  datasetGroupArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
