% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_endpoint_config}
\alias{sagemaker_describe_endpoint_config}
\title{Returns the description of an endpoint configuration created using the
CreateEndpointConfig API}
\usage{
sagemaker_describe_endpoint_config(EndpointConfigName)
}
\arguments{
\item{EndpointConfigName}{[required] The name of the endpoint configuration.}
}
\value{
A list with the following syntax:\preformatted{list(
  EndpointConfigName = "string",
  EndpointConfigArn = "string",
  ProductionVariants = list(
    list(
      VariantName = "string",
      ModelName = "string",
      InitialInstanceCount = 123,
      InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.m5d.large"|"ml.m5d.xlarge"|"ml.m5d.2xlarge"|"ml.m5d.4xlarge"|"ml.m5d.12xlarge"|"ml.m5d.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.large"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.g4dn.xlarge"|"ml.g4dn.2xlarge"|"ml.g4dn.4xlarge"|"ml.g4dn.8xlarge"|"ml.g4dn.12xlarge"|"ml.g4dn.16xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.12xlarge"|"ml.r5.24xlarge"|"ml.r5d.large"|"ml.r5d.xlarge"|"ml.r5d.2xlarge"|"ml.r5d.4xlarge"|"ml.r5d.12xlarge"|"ml.r5d.24xlarge"|"ml.inf1.xlarge"|"ml.inf1.2xlarge"|"ml.inf1.6xlarge"|"ml.inf1.24xlarge",
      InitialVariantWeight = 123.0,
      AcceleratorType = "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"|"ml.eia2.medium"|"ml.eia2.large"|"ml.eia2.xlarge"
    )
  ),
  DataCaptureConfig = list(
    EnableCapture = TRUE|FALSE,
    InitialSamplingPercentage = 123,
    DestinationS3Uri = "string",
    KmsKeyId = "string",
    CaptureOptions = list(
      list(
        CaptureMode = "Input"|"Output"
      )
    ),
    CaptureContentTypeHeader = list(
      CsvContentTypes = list(
        "string"
      ),
      JsonContentTypes = list(
        "string"
      )
    )
  ),
  KmsKeyId = "string",
  CreationTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Returns the description of an endpoint configuration created using the
\code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}} API.
}
\section{Request syntax}{
\preformatted{svc$describe_endpoint_config(
  EndpointConfigName = "string"
)
}
}

\keyword{internal}
