% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_get_document_text_detection}
\alias{textract_get_document_text_detection}
\title{Gets the results for an Amazon Textract asynchronous operation that
detects text in a document}
\usage{
textract_get_document_text_detection(JobId, MaxResults, NextToken)
}
\arguments{
\item{JobId}{[required] A unique identifier for the text detection job. The \code{JobId} is returned
from \code{StartDocumentTextDetection}. A \code{JobId} value is only valid for 7
days.}

\item{MaxResults}{The maximum number of results to return per paginated call. The largest
value you can specify is 1,000. If you specify a value greater than
1,000, a maximum of 1,000 results is returned. The default value is
1,000.}

\item{NextToken}{If the previous response was incomplete (because there are more blocks
to retrieve), Amazon Textract returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
blocks.}
}
\description{
Gets the results for an Amazon Textract asynchronous operation that
detects text in a document. Amazon Textract can detect lines of text and
the words that make up a line of text.

You start asynchronous text detection by calling
StartDocumentTextDetection, which returns a job identifier (\code{JobId}).
When the text detection operation finishes, Amazon Textract publishes a
completion status to the Amazon Simple Notification Service (Amazon SNS)
topic that's registered in the initial call to
\code{StartDocumentTextDetection}. To get the results of the text-detection
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call \code{GetDocumentTextDetection}, and pass
the job identifier (\code{JobId}) from the initial call to
\code{StartDocumentTextDetection}.

\code{GetDocumentTextDetection} returns an array of Block objects.

Each document page has as an associated \code{Block} of type PAGE. Each PAGE
\code{Block} object is the parent of LINE \code{Block} objects that represent the
lines of detected text on a page. A LINE \code{Block} object is a parent for
each word that makes up the line. Words are represented by \code{Block}
objects of type WORD.

Use the MaxResults parameter to limit the number of blocks that are
returned. If there are more results than specified in \code{MaxResults}, the
value of \code{NextToken} in the operation response contains a pagination
token for getting the next set of results. To get the next page of
results, call \code{GetDocumentTextDetection}, and populate the \code{NextToken}
request parameter with the token value that's returned from the previous
call to \code{GetDocumentTextDetection}.

For more information, see \href{https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html}{Document Text Detection}.
}
\section{Request syntax}{
\preformatted{svc$get_document_text_detection(
  JobId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
