% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_artifacts}
\alias{sagemaker_list_artifacts}
\title{Lists the artifacts in your account and their properties}
\usage{
sagemaker_list_artifacts(SourceUri, ArtifactType, CreatedAfter,
  CreatedBefore, SortBy, SortOrder, NextToken, MaxResults)
}
\arguments{
\item{SourceUri}{A filter that returns only artifacts with the specified source URI.}

\item{ArtifactType}{A filter that returns only artifacts of the specified type.}

\item{CreatedAfter}{A filter that returns only artifacts created on or after the specified
time.}

\item{CreatedBefore}{A filter that returns only artifacts created on or before the specified
time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}

\item{NextToken}{If the previous call to \code{ListArtifacts} didn't return the full set of
artifacts, the call returns a token for getting the next set of
artifacts.}

\item{MaxResults}{The maximum number of artifacts to return in the response. The default
value is 10.}
}
\description{
Lists the artifacts in your account and their properties.
}
\section{Request syntax}{
\preformatted{svc$list_artifacts(
  SourceUri = "string",
  ArtifactType = "string",
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
