% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_event_tracker}
\alias{personalize_create_event_tracker}
\title{Creates an event tracker that you use when sending event data to the
specified dataset group using the PutEvents API}
\usage{
personalize_create_event_tracker(name, datasetGroupArn)
}
\arguments{
\item{name}{[required] The name for the event tracker.}

\item{datasetGroupArn}{[required] The Amazon Resource Name (ARN) of the dataset group that receives the
event data.}
}
\description{
Creates an event tracker that you use when sending event data to the
specified dataset group using the
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html}{PutEvents}
API.

When Amazon Personalize creates an event tracker, it also creates an
\emph{event-interactions} dataset in the dataset group associated with the
event tracker. The event-interactions dataset stores the event data from
the \code{PutEvents} call. The contents of this dataset are not available to
the user.

Only one event tracker can be associated with a dataset group. You will
get an error if you call \code{CreateEventTracker} using the same dataset
group as an existing event tracker.

When you send event data you include your tracking ID. The tracking ID
identifies the customer and authorizes the customer to send the data.

The event tracker can be in one of the following states:
\itemize{
\item CREATE PENDING > CREATE IN\\_PROGRESS > ACTIVE -or- CREATE
FAILED
\item DELETE PENDING > DELETE IN\\_PROGRESS
}

To get the status of the event tracker, call DescribeEventTracker.

The event tracker must be in the ACTIVE state before using the tracking
ID.

\strong{Related APIs}
\itemize{
\item ListEventTrackers
\item DescribeEventTracker
\item DeleteEventTracker
}
}
\section{Request syntax}{
\preformatted{svc$create_event_tracker(
  name = "string",
  datasetGroupArn = "string"
)
}
}

\keyword{internal}
