% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_start_transcription_job}
\alias{transcribeservice_start_transcription_job}
\title{Starts an asynchronous job to transcribe speech to text}
\usage{
transcribeservice_start_transcription_job(TranscriptionJobName,
  LanguageCode, MediaSampleRateHertz, MediaFormat, Media,
  OutputBucketName, Settings)
}
\arguments{
\item{TranscriptionJobName}{[required] The name of the job. Note that you can't use the strings "." or
".." by themselves as the job name. The name must also be unique
within an AWS account.}

\item{LanguageCode}{[required] The language code for the language used in the input media file.}

\item{MediaSampleRateHertz}{The sample rate, in Hertz, of the audio track in the input media file.}

\item{MediaFormat}{[required] The format of the input media file.}

\item{Media}{[required] An object that describes the input media for a transcription job.}

\item{OutputBucketName}{The location where the transcription is stored.

If you set the \code{OutputBucketName}, Amazon Transcribe puts the
transcription in the specified S3 bucket. When you call the
GetTranscriptionJob operation, the operation returns this location in
the \code{TranscriptFileUri} field. The S3 bucket must have permissions that
allow Amazon Transcribe to put files in the bucket. For more
information, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user}{Permissions Required for IAM User Roles}.

Amazon Transcribe uses the default Amazon S3 key for server-side
encryption of transcripts that are placed in your S3 bucket. You can't
specify your own encryption key.

If you don't set the \code{OutputBucketName}, Amazon Transcribe generates a
pre-signed URL, a shareable URL that provides secure access to your
transcription, and returns it in the \code{TranscriptFileUri} field. Use this
URL to download the transcription.}

\item{Settings}{A \code{Settings} object that provides optional settings for a transcription
job.}
}
\description{
Starts an asynchronous job to transcribe speech to text.
}
\section{Request syntax}{
\preformatted{svc$start_transcription_job(
  TranscriptionJobName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR",
  MediaSampleRateHertz = 123,
  MediaFormat = "mp3"|"mp4"|"wav"|"flac",
  Media = list(
    MediaFileUri = "string"
  ),
  OutputBucketName = "string",
  Settings = list(
    VocabularyName = "string",
    ShowSpeakerLabels = TRUE|FALSE,
    MaxSpeakerLabels = 123,
    ChannelIdentification = TRUE|FALSE
  )
)
}
}

\keyword{internal}
