% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_browser_settings}
\alias{workspacesweb_create_browser_settings}
\title{Creates a browser settings resource that can be associated with a web
portal}
\usage{
workspacesweb_create_browser_settings(
  additionalEncryptionContext = NULL,
  browserPolicy,
  clientToken = NULL,
  customerManagedKey = NULL,
  tags = NULL
)
}
\arguments{
\item{additionalEncryptionContext}{Additional encryption context of the browser settings.}

\item{browserPolicy}{[required] A JSON string containing Chrome Enterprise policies that will be applied
to all streaming sessions.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{customerManagedKey}{The custom managed key of the browser settings.}

\item{tags}{The tags to add to the browser settings resource. A tag is a key-value
pair.}
}
\description{
Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_browser_settings/} for full documentation.
}
\keyword{internal}
