% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_document_versions}
\alias{workdocs_describe_document_versions}
\title{Retrieves the document versions for the specified document}
\usage{
workdocs_describe_document_versions(
  AuthenticationToken = NULL,
  DocumentId,
  Marker = NULL,
  Limit = NULL,
  Include = NULL,
  Fields = NULL
)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{Limit}{The maximum number of versions to return with this call.}

\item{Include}{A comma-separated list of values. Specify "INITIALIZED" to include
incomplete versions.}

\item{Fields}{Specify "SOURCE" to include initialized versions and a URL for the
source document.}
}
\description{
Retrieves the document versions for the specified document.

See \url{https://paws-r.github.io/docs/workdocs/describe_document_versions.html} for full documentation.
}
\keyword{internal}
