% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivschat_operations.R
\name{ivschat_create_room}
\alias{ivschat_create_room}
\title{Creates a room that allows clients to connect and pass messages}
\usage{
ivschat_create_room(
  maximumMessageLength = NULL,
  maximumMessageRatePerSecond = NULL,
  messageReviewHandler = NULL,
  name = NULL,
  tags = NULL
)
}
\arguments{
\item{maximumMessageLength}{Maximum number of characters in a single message. Messages are expected
to be UTF-8 encoded and this limit applies specifically to
rune/code-point count, not number of bytes. Default: 500.}

\item{maximumMessageRatePerSecond}{Maximum number of messages per second that can be sent to the room (by
all clients). Default: 10.}

\item{messageReviewHandler}{Configuration information for optional review of messages.}

\item{name}{Room name. The value does not need to be unique.}

\item{tags}{Tags to attach to the resource. Array of maps, each of the form
\code{string:string (key:value)}.}
}
\description{
Creates a room that allows clients to connect and pass messages.

See \url{https://paws-r.github.io/docs/ivschat/create_room.html} for full documentation.
}
\keyword{internal}
