% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_update_connection_alias_permission}
\alias{workspaces_update_connection_alias_permission}
\title{Shares or unshares a connection alias with one account by specifying
whether that account has permission to associate the connection alias
with a directory}
\usage{
workspaces_update_connection_alias_permission(AliasId,
  ConnectionAliasPermission)
}
\arguments{
\item{AliasId}{[required] The identifier of the connection alias that you want to update
permissions for.}

\item{ConnectionAliasPermission}{[required] Indicates whether to share or unshare the connection alias with the
specified AWS account.}
}
\value{
An empty list.
}
\description{
Shares or unshares a connection alias with one account by specifying
whether that account has permission to associate the connection alias
with a directory. If the association permission is granted, the
connection alias is shared with that account. If the association
permission is revoked, the connection alias is unshared with the
account. For more information, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html}{Cross-Region Redirection for Amazon WorkSpaces}.
\itemize{
\item Before performing this operation, call
\href{https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html}{DescribeConnectionAliases}
to make sure that the current state of the connection alias is
\code{CREATED}.
\item To delete a connection alias that has been shared, the shared
account must first disassociate the connection alias from any
directories it has been associated with. Then you must unshare the
connection alias from the account it has been shared with. You can
delete a connection alias only after it is no longer shared with any
accounts or associated with any directories.
}
}
\section{Request syntax}{
\preformatted{svc$update_connection_alias_permission(
  AliasId = "string",
  ConnectionAliasPermission = list(
    SharedAccountId = "string",
    AllowAssociation = TRUE|FALSE
  )
)
}
}

\keyword{internal}
