% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_list_package_version_assets}
\alias{codeartifact_list_package_version_assets}
\title{Returns a list of AssetSummary objects for assets in a package version}
\usage{
codeartifact_list_package_version_assets(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  packageVersion,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository associated with the
package version assets.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the package that contains the
requested package version assets.}

\item{format}{[required] The format of the package that contains the requested package version
assets.}

\item{namespace}{The namespace of the package version that contains the requested package
version assets. The package component that specifies its namespace
depends on its type. For example:

The namespace is required requesting assets from package versions of the
following formats:
\itemize{
\item Maven
\item Swift
\item generic
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm or Swift package version is its \code{scope}.
\item The namespace of a generic package is its \code{namespace}.
\item Python, NuGet, Ruby, and Cargo package versions do not contain a
corresponding component, package versions of those formats do not
have a namespace.
}}

\item{package}{[required] The name of the package that contains the requested package version
assets.}

\item{packageVersion}{[required] A string that contains the package version (for example, \verb{3.5.2}).}

\item{maxResults}{The maximum number of results to return per page.}

\item{nextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html}{AssetSummary} objects for assets in a package version.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_assets/} for full documentation.
}
\keyword{internal}
