% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_service.R
\name{codecommit}
\alias{codecommit}
\title{AWS CodeCommit}
\usage{
codecommit(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
CodeCommit

This is the \emph{CodeCommit API Reference}. This reference provides
descriptions of the operations and data types for CodeCommit API along
with usage examples.

You can use the CodeCommit API to work with the following objects:

Repositories, by calling the following:
\itemize{
\item \code{\link[=codecommit_batch_get_repositories]{batch_get_repositories}}, which
returns information about one or more repositories associated with
your Amazon Web Services account.
\item \code{\link[=codecommit_create_repository]{create_repository}}, which creates
an CodeCommit repository.
\item \code{\link[=codecommit_delete_repository]{delete_repository}}, which deletes
an CodeCommit repository.
\item \code{\link[=codecommit_get_repository]{get_repository}}, which returns
information about a specified repository.
\item \code{\link[=codecommit_list_repositories]{list_repositories}}, which lists all
CodeCommit repositories associated with your Amazon Web Services
account.
\item \code{\link[=codecommit_update_repository_description]{update_repository_description}},
which sets or updates the description of the repository.
\item \code{\link[=codecommit_update_repository_encryption_key]{update_repository_encryption_key}},
which updates the Key Management Service encryption key used to
encrypt and decrypt a repository.
\item \code{\link[=codecommit_update_repository_name]{update_repository_name}}, which
changes the name of the repository. If you change the name of a
repository, no other users of that repository can access it until
you send them the new HTTPS or SSH URL to use.
}

Branches, by calling the following:
\itemize{
\item \code{\link[=codecommit_create_branch]{create_branch}}, which creates a branch
in a specified repository.
\item \code{\link[=codecommit_delete_branch]{delete_branch}}, which deletes the
specified branch in a repository unless it is the default branch.
\item \code{\link[=codecommit_get_branch]{get_branch}}, which returns information
about a specified branch.
\item \code{\link[=codecommit_list_branches]{list_branches}}, which lists all
branches for a specified repository.
\item \code{\link[=codecommit_update_default_branch]{update_default_branch}}, which
changes the default branch for a repository.
}

Files, by calling the following:
\itemize{
\item \code{\link[=codecommit_delete_file]{delete_file}}, which deletes the content
of a specified file from a specified branch.
\item \code{\link[=codecommit_get_blob]{get_blob}}, which returns the base-64 encoded
content of an individual Git blob object in a repository.
\item \code{\link[=codecommit_get_file]{get_file}}, which returns the base-64 encoded
content of a specified file.
\item \code{\link[=codecommit_get_folder]{get_folder}}, which returns the contents of
a specified folder or directory.
\item \code{\link[=codecommit_list_file_commit_history]{list_file_commit_history}},
which retrieves a list of commits and changes to a specified file.
\item \code{\link[=codecommit_put_file]{put_file}}, which adds or modifies a single
file in a specified repository and branch.
}

Commits, by calling the following:
\itemize{
\item \code{\link[=codecommit_batch_get_commits]{batch_get_commits}}, which returns
information about one or more commits in a repository.
\item \code{\link[=codecommit_create_commit]{create_commit}}, which creates a commit
for changes to a repository.
\item \code{\link[=codecommit_get_commit]{get_commit}}, which returns information
about a commit, including commit messages and author and committer
information.
\item \code{\link[=codecommit_get_differences]{get_differences}}, which returns
information about the differences in a valid commit specifier (such
as a branch, tag, HEAD, commit ID, or other fully qualified
reference).
}

Merges, by calling the following:
\itemize{
\item \code{\link[=codecommit_batch_describe_merge_conflicts]{batch_describe_merge_conflicts}},
which returns information about conflicts in a merge between commits
in a repository.
\item \code{\link[=codecommit_create_unreferenced_merge_commit]{create_unreferenced_merge_commit}},
which creates an unreferenced commit between two branches or commits
for the purpose of comparing them and identifying any potential
conflicts.
\item \code{\link[=codecommit_describe_merge_conflicts]{describe_merge_conflicts}},
which returns information about merge conflicts between the base,
source, and destination versions of a file in a potential merge.
\item \code{\link[=codecommit_get_merge_commit]{get_merge_commit}}, which returns
information about the merge between a source and destination commit.
\item \code{\link[=codecommit_get_merge_conflicts]{get_merge_conflicts}}, which
returns information about merge conflicts between the source and
destination branch in a pull request.
\item \code{\link[=codecommit_get_merge_options]{get_merge_options}}, which returns
information about the available merge options between two branches
or commit specifiers.
\item \code{\link[=codecommit_merge_branches_by_fast_forward]{merge_branches_by_fast_forward}},
which merges two branches using the fast-forward merge option.
\item \code{\link[=codecommit_merge_branches_by_squash]{merge_branches_by_squash}},
which merges two branches using the squash merge option.
\item \code{\link[=codecommit_merge_branches_by_three_way]{merge_branches_by_three_way}},
which merges two branches using the three-way merge option.
}

Pull requests, by calling the following:
\itemize{
\item \code{\link[=codecommit_create_pull_request]{create_pull_request}}, which
creates a pull request in a specified repository.
\item \code{\link[=codecommit_create_pull_request_approval_rule]{create_pull_request_approval_rule}},
which creates an approval rule for a specified pull request.
\item \code{\link[=codecommit_delete_pull_request_approval_rule]{delete_pull_request_approval_rule}},
which deletes an approval rule for a specified pull request.
\item \code{\link[=codecommit_describe_pull_request_events]{describe_pull_request_events}},
which returns information about one or more pull request events.
\item \code{\link[=codecommit_evaluate_pull_request_approval_rules]{evaluate_pull_request_approval_rules}},
which evaluates whether a pull request has met all the conditions
specified in its associated approval rules.
\item \code{\link[=codecommit_get_comments_for_pull_request]{get_comments_for_pull_request}},
which returns information about comments on a specified pull
request.
\item \code{\link[=codecommit_get_pull_request]{get_pull_request}}, which returns
information about a specified pull request.
\item \code{\link[=codecommit_get_pull_request_approval_states]{get_pull_request_approval_states}},
which returns information about the approval states for a specified
pull request.
\item \code{\link[=codecommit_get_pull_request_override_state]{get_pull_request_override_state}},
which returns information about whether approval rules have been set
aside (overriden) for a pull request, and if so, the Amazon Resource
Name (ARN) of the user or identity that overrode the rules and their
requirements for the pull request.
\item \code{\link[=codecommit_list_pull_requests]{list_pull_requests}}, which lists
all pull requests for a repository.
\item \code{\link[=codecommit_merge_pull_request_by_fast_forward]{merge_pull_request_by_fast_forward}},
which merges the source destination branch of a pull request into
the specified destination branch for that pull request using the
fast-forward merge option.
\item \code{\link[=codecommit_merge_pull_request_by_squash]{merge_pull_request_by_squash}},
which merges the source destination branch of a pull request into
the specified destination branch for that pull request using the
squash merge option.
\item \code{\link[=codecommit_merge_pull_request_by_three_way]{merge_pull_request_by_three_way}},
which merges the source destination branch of a pull request into
the specified destination branch for that pull request using the
three-way merge option.
\item \code{\link[=codecommit_override_pull_request_approval_rules]{override_pull_request_approval_rules}},
which sets aside all approval rule requirements for a pull request.
\item \code{\link[=codecommit_post_comment_for_pull_request]{post_comment_for_pull_request}},
which posts a comment to a pull request at the specified line, file,
or request.
\item \code{\link[=codecommit_update_pull_request_approval_rule_content]{update_pull_request_approval_rule_content}},
which updates the structure of an approval rule for a pull request.
\item \code{\link[=codecommit_update_pull_request_approval_state]{update_pull_request_approval_state}},
which updates the state of an approval on a pull request.
\item \code{\link[=codecommit_update_pull_request_description]{update_pull_request_description}},
which updates the description of a pull request.
\item \code{\link[=codecommit_update_pull_request_status]{update_pull_request_status}},
which updates the status of a pull request.
\item \code{\link[=codecommit_update_pull_request_title]{update_pull_request_title}},
which updates the title of a pull request.
}

Approval rule templates, by calling the following:
\itemize{
\item \code{\link[=codecommit_associate_approval_rule_template_with_repository]{associate_approval_rule_template_with_repository}},
which associates a template with a specified repository. After the
template is associated with a repository, CodeCommit creates
approval rules that match the template conditions on every pull
request created in the specified repository.
\item \code{\link[=codecommit_batch_associate_approval_rule_template_with_repositories]{batch_associate_approval_rule_template_with_repositories}},
which associates a template with one or more specified repositories.
After the template is associated with a repository, CodeCommit
creates approval rules that match the template conditions on every
pull request created in the specified repositories.
\item \code{\link[=codecommit_batch_disassociate_approval_rule_template_from_repositories]{batch_disassociate_approval_rule_template_from_repositories}},
which removes the association between a template and specified
repositories so that approval rules based on the template are not
automatically created when pull requests are created in those
repositories.
\item \code{\link[=codecommit_create_approval_rule_template]{create_approval_rule_template}},
which creates a template for approval rules that can then be
associated with one or more repositories in your Amazon Web Services
account.
\item \code{\link[=codecommit_delete_approval_rule_template]{delete_approval_rule_template}},
which deletes the specified template. It does not remove approval
rules on pull requests already created with the template.
\item \code{\link[=codecommit_disassociate_approval_rule_template_from_repository]{disassociate_approval_rule_template_from_repository}},
which removes the association between a template and a repository so
that approval rules based on the template are not automatically
created when pull requests are created in the specified repository.
\item \code{\link[=codecommit_get_approval_rule_template]{get_approval_rule_template}},
which returns information about an approval rule template.
\item \code{\link[=codecommit_list_approval_rule_templates]{list_approval_rule_templates}},
which lists all approval rule templates in the Amazon Web Services
Region in your Amazon Web Services account.
\item \code{\link[=codecommit_list_associated_approval_rule_templates_for_repository]{list_associated_approval_rule_templates_for_repository}},
which lists all approval rule templates that are associated with a
specified repository.
\item \code{\link[=codecommit_list_repositories_for_approval_rule_template]{list_repositories_for_approval_rule_template}},
which lists all repositories associated with the specified approval
rule template.
\item \code{\link[=codecommit_update_approval_rule_template_description]{update_approval_rule_template_description}},
which updates the description of an approval rule template.
\item \code{\link[=codecommit_update_approval_rule_template_name]{update_approval_rule_template_name}},
which updates the name of an approval rule template.
\item \code{\link[=codecommit_update_approval_rule_template_content]{update_approval_rule_template_content}},
which updates the content of an approval rule template.
}

Comments in a repository, by calling the following:
\itemize{
\item \code{\link[=codecommit_delete_comment_content]{delete_comment_content}}, which
deletes the content of a comment on a commit in a repository.
\item \code{\link[=codecommit_get_comment]{get_comment}}, which returns information
about a comment on a commit.
\item \code{\link[=codecommit_get_comment_reactions]{get_comment_reactions}}, which
returns information about emoji reactions to comments.
\item \code{\link[=codecommit_get_comments_for_compared_commit]{get_comments_for_compared_commit}},
which returns information about comments on the comparison between
two commit specifiers in a repository.
\item \code{\link[=codecommit_post_comment_for_compared_commit]{post_comment_for_compared_commit}},
which creates a comment on the comparison between two commit
specifiers in a repository.
\item \code{\link[=codecommit_post_comment_reply]{post_comment_reply}}, which creates
a reply to a comment.
\item \code{\link[=codecommit_put_comment_reaction]{put_comment_reaction}}, which
creates or updates an emoji reaction to a comment.
\item \code{\link[=codecommit_update_comment]{update_comment}}, which updates the
content of a comment on a commit in a repository.
}

Tags used to tag resources in CodeCommit (not Git tags), by calling the
following:
\itemize{
\item \code{\link[=codecommit_list_tags_for_resource]{list_tags_for_resource}}, which
gets information about Amazon Web Servicestags for a specified
Amazon Resource Name (ARN) in CodeCommit.
\item \code{\link[=codecommit_tag_resource]{tag_resource}}, which adds or updates
tags for a resource in CodeCommit.
\item \code{\link[=codecommit_untag_resource]{untag_resource}}, which removes tags
for a resource in CodeCommit.
}

Triggers, by calling the following:
\itemize{
\item \code{\link[=codecommit_get_repository_triggers]{get_repository_triggers}},
which returns information about triggers configured for a
repository.
\item \code{\link[=codecommit_put_repository_triggers]{put_repository_triggers}},
which replaces all triggers for a repository and can be used to
create or delete triggers.
\item \code{\link[=codecommit_test_repository_triggers]{test_repository_triggers}},
which tests the functionality of a repository trigger by sending
data to the trigger target.
}

For information about how to use CodeCommit, see the \href{https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html}{CodeCommit User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codecommit(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codecommit_associate_approval_rule_template_with_repository]{associate_approval_rule_template_with_repository} \tab Creates an association between an approval rule template and a specified repository\cr
\link[=codecommit_batch_associate_approval_rule_template_with_repositories]{batch_associate_approval_rule_template_with_repositories} \tab Creates an association between an approval rule template and one or more specified repositories\cr
\link[=codecommit_batch_describe_merge_conflicts]{batch_describe_merge_conflicts} \tab Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy\cr
\link[=codecommit_batch_disassociate_approval_rule_template_from_repositories]{batch_disassociate_approval_rule_template_from_repositories} \tab Removes the association between an approval rule template and one or more specified repositories\cr
\link[=codecommit_batch_get_commits]{batch_get_commits} \tab Returns information about the contents of one or more commits in a repository\cr
\link[=codecommit_batch_get_repositories]{batch_get_repositories} \tab Returns information about one or more repositories\cr
\link[=codecommit_create_approval_rule_template]{create_approval_rule_template} \tab Creates a template for approval rules that can then be associated with one or more repositories in your Amazon Web Services account\cr
\link[=codecommit_create_branch]{create_branch} \tab Creates a branch in a repository and points the branch to a commit\cr
\link[=codecommit_create_commit]{create_commit} \tab Creates a commit for a repository on the tip of a specified branch\cr
\link[=codecommit_create_pull_request]{create_pull_request} \tab Creates a pull request in the specified repository\cr
\link[=codecommit_create_pull_request_approval_rule]{create_pull_request_approval_rule} \tab Creates an approval rule for a pull request\cr
\link[=codecommit_create_repository]{create_repository} \tab Creates a new, empty repository\cr
\link[=codecommit_create_unreferenced_merge_commit]{create_unreferenced_merge_commit} \tab Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy\cr
\link[=codecommit_delete_approval_rule_template]{delete_approval_rule_template} \tab Deletes a specified approval rule template\cr
\link[=codecommit_delete_branch]{delete_branch} \tab Deletes a branch from a repository, unless that branch is the default branch for the repository\cr
\link[=codecommit_delete_comment_content]{delete_comment_content} \tab Deletes the content of a comment made on a change, file, or commit in a repository\cr
\link[=codecommit_delete_file]{delete_file} \tab Deletes a specified file from a specified branch\cr
\link[=codecommit_delete_pull_request_approval_rule]{delete_pull_request_approval_rule} \tab Deletes an approval rule from a specified pull request\cr
\link[=codecommit_delete_repository]{delete_repository} \tab Deletes a repository\cr
\link[=codecommit_describe_merge_conflicts]{describe_merge_conflicts} \tab Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy\cr
\link[=codecommit_describe_pull_request_events]{describe_pull_request_events} \tab Returns information about one or more pull request events\cr
\link[=codecommit_disassociate_approval_rule_template_from_repository]{disassociate_approval_rule_template_from_repository} \tab Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository\cr
\link[=codecommit_evaluate_pull_request_approval_rules]{evaluate_pull_request_approval_rules} \tab Evaluates whether a pull request has met all the conditions specified in its associated approval rules\cr
\link[=codecommit_get_approval_rule_template]{get_approval_rule_template} \tab Returns information about a specified approval rule template\cr
\link[=codecommit_get_blob]{get_blob} \tab Returns the base-64 encoded content of an individual blob in a repository\cr
\link[=codecommit_get_branch]{get_branch} \tab Returns information about a repository branch, including its name and the last commit ID\cr
\link[=codecommit_get_comment]{get_comment} \tab Returns the content of a comment made on a change, file, or commit in a repository\cr
\link[=codecommit_get_comment_reactions]{get_comment_reactions} \tab Returns information about reactions to a specified comment ID\cr
\link[=codecommit_get_comments_for_compared_commit]{get_comments_for_compared_commit} \tab Returns information about comments made on the comparison between two commits\cr
\link[=codecommit_get_comments_for_pull_request]{get_comments_for_pull_request} \tab Returns comments made on a pull request\cr
\link[=codecommit_get_commit]{get_commit} \tab Returns information about a commit, including commit message and committer information\cr
\link[=codecommit_get_differences]{get_differences} \tab Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference)\cr
\link[=codecommit_get_file]{get_file} \tab Returns the base-64 encoded contents of a specified file and its metadata\cr
\link[=codecommit_get_folder]{get_folder} \tab Returns the contents of a specified folder in a repository\cr
\link[=codecommit_get_merge_commit]{get_merge_commit} \tab Returns information about a specified merge commit\cr
\link[=codecommit_get_merge_conflicts]{get_merge_conflicts} \tab Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository\cr
\link[=codecommit_get_merge_options]{get_merge_options} \tab Returns information about the merge options available for merging two specified branches\cr
\link[=codecommit_get_pull_request]{get_pull_request} \tab Gets information about a pull request in a specified repository\cr
\link[=codecommit_get_pull_request_approval_states]{get_pull_request_approval_states} \tab Gets information about the approval states for a specified pull request\cr
\link[=codecommit_get_pull_request_override_state]{get_pull_request_override_state} \tab Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request\cr
\link[=codecommit_get_repository]{get_repository} \tab Returns information about a repository\cr
\link[=codecommit_get_repository_triggers]{get_repository_triggers} \tab Gets information about triggers configured for a repository\cr
\link[=codecommit_list_approval_rule_templates]{list_approval_rule_templates} \tab Lists all approval rule templates in the specified Amazon Web Services Region in your Amazon Web Services account\cr
\link[=codecommit_list_associated_approval_rule_templates_for_repository]{list_associated_approval_rule_templates_for_repository} \tab Lists all approval rule templates that are associated with a specified repository\cr
\link[=codecommit_list_branches]{list_branches} \tab Gets information about one or more branches in a repository\cr
\link[=codecommit_list_file_commit_history]{list_file_commit_history} \tab Retrieves a list of commits and changes to a specified file\cr
\link[=codecommit_list_pull_requests]{list_pull_requests} \tab Returns a list of pull requests for a specified repository\cr
\link[=codecommit_list_repositories]{list_repositories} \tab Gets information about one or more repositories\cr
\link[=codecommit_list_repositories_for_approval_rule_template]{list_repositories_for_approval_rule_template} \tab Lists all repositories associated with the specified approval rule template\cr
\link[=codecommit_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Servicestags for a specified Amazon Resource Name (ARN) in CodeCommit\cr
\link[=codecommit_merge_branches_by_fast_forward]{merge_branches_by_fast_forward} \tab Merges two branches using the fast-forward merge strategy\cr
\link[=codecommit_merge_branches_by_squash]{merge_branches_by_squash} \tab Merges two branches using the squash merge strategy\cr
\link[=codecommit_merge_branches_by_three_way]{merge_branches_by_three_way} \tab Merges two specified branches using the three-way merge strategy\cr
\link[=codecommit_merge_pull_request_by_fast_forward]{merge_pull_request_by_fast_forward} \tab Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy\cr
\link[=codecommit_merge_pull_request_by_squash]{merge_pull_request_by_squash} \tab Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy\cr
\link[=codecommit_merge_pull_request_by_three_way]{merge_pull_request_by_three_way} \tab Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy\cr
\link[=codecommit_override_pull_request_approval_rules]{override_pull_request_approval_rules} \tab Sets aside (overrides) all approval rule requirements for a specified pull request\cr
\link[=codecommit_post_comment_for_compared_commit]{post_comment_for_compared_commit} \tab Posts a comment on the comparison between two commits\cr
\link[=codecommit_post_comment_for_pull_request]{post_comment_for_pull_request} \tab Posts a comment on a pull request\cr
\link[=codecommit_post_comment_reply]{post_comment_reply} \tab Posts a comment in reply to an existing comment on a comparison between commits or a pull request\cr
\link[=codecommit_put_comment_reaction]{put_comment_reaction} \tab Adds or updates a reaction to a specified comment for the user whose identity is used to make the request\cr
\link[=codecommit_put_file]{put_file} \tab Adds or updates a file in a branch in an CodeCommit repository, and generates a commit for the addition in the specified branch\cr
\link[=codecommit_put_repository_triggers]{put_repository_triggers} \tab Replaces all triggers for a repository\cr
\link[=codecommit_tag_resource]{tag_resource} \tab Adds or updates tags for a resource in CodeCommit\cr
\link[=codecommit_test_repository_triggers]{test_repository_triggers} \tab Tests the functionality of repository triggers by sending information to the trigger target\cr
\link[=codecommit_untag_resource]{untag_resource} \tab Removes tags for a resource in CodeCommit\cr
\link[=codecommit_update_approval_rule_template_content]{update_approval_rule_template_content} \tab Updates the content of an approval rule template\cr
\link[=codecommit_update_approval_rule_template_description]{update_approval_rule_template_description} \tab Updates the description for a specified approval rule template\cr
\link[=codecommit_update_approval_rule_template_name]{update_approval_rule_template_name} \tab Updates the name of a specified approval rule template\cr
\link[=codecommit_update_comment]{update_comment} \tab Replaces the contents of a comment\cr
\link[=codecommit_update_default_branch]{update_default_branch} \tab Sets or changes the default branch name for the specified repository\cr
\link[=codecommit_update_pull_request_approval_rule_content]{update_pull_request_approval_rule_content} \tab Updates the structure of an approval rule created specifically for a pull request\cr
\link[=codecommit_update_pull_request_approval_state]{update_pull_request_approval_state} \tab Updates the state of a user's approval on a pull request\cr
\link[=codecommit_update_pull_request_description]{update_pull_request_description} \tab Replaces the contents of the description of a pull request\cr
\link[=codecommit_update_pull_request_status]{update_pull_request_status} \tab Updates the status of a pull request\cr
\link[=codecommit_update_pull_request_title]{update_pull_request_title} \tab Replaces the title of a pull request\cr
\link[=codecommit_update_repository_description]{update_repository_description} \tab Sets or changes the comment or description for a repository\cr
\link[=codecommit_update_repository_encryption_key]{update_repository_encryption_key} \tab Updates the Key Management Service encryption key used to encrypt and decrypt a CodeCommit repository\cr
\link[=codecommit_update_repository_name]{update_repository_name} \tab Renames a repository
}
}

\examples{
\dontrun{
svc <- codecommit()
svc$associate_approval_rule_template_with_repository(
  Foo = 123
)
}

}
