# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codepipeline_service.R
NULL

#' Returns information about a specified job and whether that job has been
#' received by the job worker
#'
#' @description
#' Returns information about a specified job and whether that job has been received by the job worker. Used for custom actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_acknowledge_job/](https://www.paws-r-sdk.com/docs/codepipeline_acknowledge_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job for which you want to confirm
#' receipt.
#' @param nonce &#91;required&#93; A system-generated random number that CodePipeline uses to ensure that
#' the job is being worked on by only one job worker. Get this number from
#' the response of the [`poll_for_jobs`][codepipeline_poll_for_jobs]
#' request that returned this job.
#'
#' @keywords internal
#'
#' @rdname codepipeline_acknowledge_job
codepipeline_acknowledge_job <- function(jobId, nonce) {
  op <- new_operation(
    name = "AcknowledgeJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$acknowledge_job_input(jobId = jobId, nonce = nonce)
  output <- .codepipeline$acknowledge_job_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$acknowledge_job <- codepipeline_acknowledge_job

#' Confirms a job worker has received the specified job
#'
#' @description
#' Confirms a job worker has received the specified job. Used for partner actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_acknowledge_third_party_job/](https://www.paws-r-sdk.com/docs/codepipeline_acknowledge_third_party_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job.
#' @param nonce &#91;required&#93; A system-generated random number that CodePipeline uses to ensure that
#' the job is being worked on by only one job worker. Get this number from
#' the response to a
#' [`get_third_party_job_details`][codepipeline_get_third_party_job_details]
#' request.
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#'
#' @keywords internal
#'
#' @rdname codepipeline_acknowledge_third_party_job
codepipeline_acknowledge_third_party_job <- function(jobId, nonce, clientToken) {
  op <- new_operation(
    name = "AcknowledgeThirdPartyJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$acknowledge_third_party_job_input(jobId = jobId, nonce = nonce, clientToken = clientToken)
  output <- .codepipeline$acknowledge_third_party_job_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$acknowledge_third_party_job <- codepipeline_acknowledge_third_party_job

#' Creates a new custom action that can be used in all pipelines associated
#' with the Amazon Web Services account
#'
#' @description
#' Creates a new custom action that can be used in all pipelines associated with the Amazon Web Services account. Only used for custom actions.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_create_custom_action_type/](https://www.paws-r-sdk.com/docs/codepipeline_create_custom_action_type/) for full documentation.
#'
#' @param category &#91;required&#93; The category of the custom action, such as a build action or a test
#' action.
#' @param provider &#91;required&#93; The provider of the service used in the custom action, such as
#' CodeDeploy.
#' @param version &#91;required&#93; The version identifier of the custom action.
#' @param settings URLs that provide users information about this custom action.
#' @param configurationProperties The configuration properties for the custom action.
#' 
#' You can refer to a name in the configuration properties of the custom
#' action within the URL templates by following the format of
#' \{Config:name\}, as long as the configuration property is both
#' required and not secret. For more information, see [Create a Custom
#' Action for a
#' Pipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html).
#' @param inputArtifactDetails &#91;required&#93; The details of the input artifact for the action, such as its commit ID.
#' @param outputArtifactDetails &#91;required&#93; The details of the output artifact of the action, such as its commit ID.
#' @param tags The tags for the custom action.
#'
#' @keywords internal
#'
#' @rdname codepipeline_create_custom_action_type
codepipeline_create_custom_action_type <- function(category, provider, version, settings = NULL, configurationProperties = NULL, inputArtifactDetails, outputArtifactDetails, tags = NULL) {
  op <- new_operation(
    name = "CreateCustomActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$create_custom_action_type_input(category = category, provider = provider, version = version, settings = settings, configurationProperties = configurationProperties, inputArtifactDetails = inputArtifactDetails, outputArtifactDetails = outputArtifactDetails, tags = tags)
  output <- .codepipeline$create_custom_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$create_custom_action_type <- codepipeline_create_custom_action_type

#' Creates a pipeline
#'
#' @description
#' Creates a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_create_pipeline/](https://www.paws-r-sdk.com/docs/codepipeline_create_pipeline/) for full documentation.
#'
#' @param pipeline &#91;required&#93; Represents the structure of actions and stages to be performed in the
#' pipeline.
#' @param tags The tags for the pipeline.
#'
#' @keywords internal
#'
#' @rdname codepipeline_create_pipeline
codepipeline_create_pipeline <- function(pipeline, tags = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$create_pipeline_input(pipeline = pipeline, tags = tags)
  output <- .codepipeline$create_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$create_pipeline <- codepipeline_create_pipeline

#' Marks a custom action as deleted
#'
#' @description
#' Marks a custom action as deleted. [`poll_for_jobs`][codepipeline_poll_for_jobs] for the custom action fails after the action is marked for deletion. Used for custom actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_delete_custom_action_type/](https://www.paws-r-sdk.com/docs/codepipeline_delete_custom_action_type/) for full documentation.
#'
#' @param category &#91;required&#93; The category of the custom action that you want to delete, such as
#' source or deploy.
#' @param provider &#91;required&#93; The provider of the service used in the custom action, such as
#' CodeDeploy.
#' @param version &#91;required&#93; The version of the custom action to delete.
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_custom_action_type
codepipeline_delete_custom_action_type <- function(category, provider, version) {
  op <- new_operation(
    name = "DeleteCustomActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_custom_action_type_input(category = category, provider = provider, version = version)
  output <- .codepipeline$delete_custom_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_custom_action_type <- codepipeline_delete_custom_action_type

#' Deletes the specified pipeline
#'
#' @description
#' Deletes the specified pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_delete_pipeline/](https://www.paws-r-sdk.com/docs/codepipeline_delete_pipeline/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the pipeline to be deleted.
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_pipeline
codepipeline_delete_pipeline <- function(name) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_pipeline_input(name = name)
  output <- .codepipeline$delete_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_pipeline <- codepipeline_delete_pipeline

#' Deletes a previously created webhook by name
#'
#' @description
#' Deletes a previously created webhook by name. Deleting the webhook stops CodePipeline from starting a pipeline every time an external event occurs. The API returns successfully when trying to delete a webhook that is already deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different URL.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_delete_webhook/](https://www.paws-r-sdk.com/docs/codepipeline_delete_webhook/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the webhook you want to delete.
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_webhook
codepipeline_delete_webhook <- function(name) {
  op <- new_operation(
    name = "DeleteWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_webhook_input(name = name)
  output <- .codepipeline$delete_webhook_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_webhook <- codepipeline_delete_webhook

#' Removes the connection between the webhook that was created by
#' CodePipeline and the external tool with events to be detected
#'
#' @description
#' Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected. Currently supported only for webhooks that target an action type of GitHub.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_deregister_webhook_with_third_party/](https://www.paws-r-sdk.com/docs/codepipeline_deregister_webhook_with_third_party/) for full documentation.
#'
#' @param webhookName The name of the webhook you want to deregister.
#'
#' @keywords internal
#'
#' @rdname codepipeline_deregister_webhook_with_third_party
codepipeline_deregister_webhook_with_third_party <- function(webhookName = NULL) {
  op <- new_operation(
    name = "DeregisterWebhookWithThirdParty",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$deregister_webhook_with_third_party_input(webhookName = webhookName)
  output <- .codepipeline$deregister_webhook_with_third_party_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$deregister_webhook_with_third_party <- codepipeline_deregister_webhook_with_third_party

#' Prevents artifacts in a pipeline from transitioning to the next stage in
#' the pipeline
#'
#' @description
#' Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_disable_stage_transition/](https://www.paws-r-sdk.com/docs/codepipeline_disable_stage_transition/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline in which you want to disable the flow of
#' artifacts from one stage to another.
#' @param stageName &#91;required&#93; The name of the stage where you want to disable the inbound or outbound
#' transition of artifacts.
#' @param transitionType &#91;required&#93; Specifies whether artifacts are prevented from transitioning into the
#' stage and being processed by the actions in that stage (inbound), or
#' prevented from transitioning from the stage after they have been
#' processed by the actions in that stage (outbound).
#' @param reason &#91;required&#93; The reason given to the user that a stage is disabled, such as waiting
#' for manual approval or manual tests. This message is displayed in the
#' pipeline console UI.
#'
#' @keywords internal
#'
#' @rdname codepipeline_disable_stage_transition
codepipeline_disable_stage_transition <- function(pipelineName, stageName, transitionType, reason) {
  op <- new_operation(
    name = "DisableStageTransition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$disable_stage_transition_input(pipelineName = pipelineName, stageName = stageName, transitionType = transitionType, reason = reason)
  output <- .codepipeline$disable_stage_transition_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$disable_stage_transition <- codepipeline_disable_stage_transition

#' Enables artifacts in a pipeline to transition to a stage in a pipeline
#'
#' @description
#' Enables artifacts in a pipeline to transition to a stage in a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_enable_stage_transition/](https://www.paws-r-sdk.com/docs/codepipeline_enable_stage_transition/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline in which you want to enable the flow of
#' artifacts from one stage to another.
#' @param stageName &#91;required&#93; The name of the stage where you want to enable the transition of
#' artifacts, either into the stage (inbound) or from that stage to the
#' next stage (outbound).
#' @param transitionType &#91;required&#93; Specifies whether artifacts are allowed to enter the stage and be
#' processed by the actions in that stage (inbound) or whether already
#' processed artifacts are allowed to transition to the next stage
#' (outbound).
#'
#' @keywords internal
#'
#' @rdname codepipeline_enable_stage_transition
codepipeline_enable_stage_transition <- function(pipelineName, stageName, transitionType) {
  op <- new_operation(
    name = "EnableStageTransition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$enable_stage_transition_input(pipelineName = pipelineName, stageName = stageName, transitionType = transitionType)
  output <- .codepipeline$enable_stage_transition_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$enable_stage_transition <- codepipeline_enable_stage_transition

#' Returns information about an action type created for an external
#' provider, where the action is to be used by customers of the external
#' provider
#'
#' @description
#' Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider. The action can be created with any supported integration model.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_action_type/](https://www.paws-r-sdk.com/docs/codepipeline_get_action_type/) for full documentation.
#'
#' @param category &#91;required&#93; Defines what kind of action can be taken in the stage. The following are
#' the valid values:
#' 
#' -   `Source`
#' 
#' -   `Build`
#' 
#' -   `Test`
#' 
#' -   `Deploy`
#' 
#' -   `Approval`
#' 
#' -   `Invoke`
#' @param owner &#91;required&#93; The creator of an action type that was created with any supported
#' integration model. There are two valid values: `AWS` and `ThirdParty`.
#' @param provider &#91;required&#93; The provider of the action type being called. The provider name is
#' specified when the action type is created.
#' @param version &#91;required&#93; A string that describes the action type version.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_action_type
codepipeline_get_action_type <- function(category, owner, provider, version) {
  op <- new_operation(
    name = "GetActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_action_type_input(category = category, owner = owner, provider = provider, version = version)
  output <- .codepipeline$get_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_action_type <- codepipeline_get_action_type

#' Returns information about a job
#'
#' @description
#' Returns information about a job. Used for custom actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_job_details/](https://www.paws-r-sdk.com/docs/codepipeline_get_job_details/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID for the job.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_job_details
codepipeline_get_job_details <- function(jobId) {
  op <- new_operation(
    name = "GetJobDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_job_details_input(jobId = jobId)
  output <- .codepipeline$get_job_details_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_job_details <- codepipeline_get_job_details

#' Returns the metadata, structure, stages, and actions of a pipeline
#'
#' @description
#' Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with [`update_pipeline`][codepipeline_update_pipeline].
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline/](https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the pipeline for which you want to get information. Pipeline
#' names must be unique in an Amazon Web Services account.
#' @param version The version number of the pipeline. If you do not specify a version,
#' defaults to the current version.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline
codepipeline_get_pipeline <- function(name, version = NULL) {
  op <- new_operation(
    name = "GetPipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_input(name = name, version = version)
  output <- .codepipeline$get_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline <- codepipeline_get_pipeline

#' Returns information about an execution of a pipeline, including details
#' about artifacts, the pipeline execution ID, and the name, version, and
#' status of the pipeline
#'
#' @description
#' Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline_execution/](https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline_execution/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline about which you want to get execution details.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution about which you want to get execution
#' details.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline_execution
codepipeline_get_pipeline_execution <- function(pipelineName, pipelineExecutionId) {
  op <- new_operation(
    name = "GetPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_execution_input(pipelineName = pipelineName, pipelineExecutionId = pipelineExecutionId)
  output <- .codepipeline$get_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline_execution <- codepipeline_get_pipeline_execution

#' Returns information about the state of a pipeline, including the stages
#' and actions
#'
#' @description
#' Returns information about the state of a pipeline, including the stages and actions.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline_state/](https://www.paws-r-sdk.com/docs/codepipeline_get_pipeline_state/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the pipeline about which you want to get information.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline_state
codepipeline_get_pipeline_state <- function(name) {
  op <- new_operation(
    name = "GetPipelineState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_state_input(name = name)
  output <- .codepipeline$get_pipeline_state_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline_state <- codepipeline_get_pipeline_state

#' Requests the details of a job for a third party action
#'
#' @description
#' Requests the details of a job for a third party action. Used for partner actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_get_third_party_job_details/](https://www.paws-r-sdk.com/docs/codepipeline_get_third_party_job_details/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID used for identifying the job.
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_third_party_job_details
codepipeline_get_third_party_job_details <- function(jobId, clientToken) {
  op <- new_operation(
    name = "GetThirdPartyJobDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_third_party_job_details_input(jobId = jobId, clientToken = clientToken)
  output <- .codepipeline$get_third_party_job_details_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_third_party_job_details <- codepipeline_get_third_party_job_details

#' Lists the action executions that have occurred in a pipeline
#'
#' @description
#' Lists the action executions that have occurred in a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_action_executions/](https://www.paws-r-sdk.com/docs/codepipeline_list_action_executions/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline for which you want to list action execution
#' history.
#' @param filter Input information used to filter action execution history.
#' @param maxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. Action execution history is retained for up to 12 months, based
#' on action execution start times. Default value is 100.
#' 
#' Detailed execution history is available for executions run on or after
#' February 21, 2019.
#' @param nextToken The token that was returned from the previous
#' [`list_action_executions`][codepipeline_list_action_executions] call,
#' which can be used to return the next set of action executions in the
#' list.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_action_executions
codepipeline_list_action_executions <- function(pipelineName, filter = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActionExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "actionExecutionDetails")
  )
  input <- .codepipeline$list_action_executions_input(pipelineName = pipelineName, filter = filter, maxResults = maxResults, nextToken = nextToken)
  output <- .codepipeline$list_action_executions_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_action_executions <- codepipeline_list_action_executions

#' Gets a summary of all CodePipeline action types associated with your
#' account
#'
#' @description
#' Gets a summary of all CodePipeline action types associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_action_types/](https://www.paws-r-sdk.com/docs/codepipeline_list_action_types/) for full documentation.
#'
#' @param actionOwnerFilter Filters the list of action types to those created by a specified entity.
#' @param nextToken An identifier that was returned from the previous list action types
#' call, which can be used to return the next set of action types in the
#' list.
#' @param regionFilter The Region to filter on for the list of action types.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_action_types
codepipeline_list_action_types <- function(actionOwnerFilter = NULL, nextToken = NULL, regionFilter = NULL) {
  op <- new_operation(
    name = "ListActionTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "actionTypes")
  )
  input <- .codepipeline$list_action_types_input(actionOwnerFilter = actionOwnerFilter, nextToken = nextToken, regionFilter = regionFilter)
  output <- .codepipeline$list_action_types_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_action_types <- codepipeline_list_action_types

#' Gets a summary of the most recent executions for a pipeline
#'
#' @description
#' Gets a summary of the most recent executions for a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_pipeline_executions/](https://www.paws-r-sdk.com/docs/codepipeline_list_pipeline_executions/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline for which you want to get execution summary
#' information.
#' @param maxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. Pipeline history is limited to the most recent 12 months, based
#' on pipeline execution start times. Default value is 100.
#' @param nextToken The token that was returned from the previous
#' [`list_pipeline_executions`][codepipeline_list_pipeline_executions]
#' call, which can be used to return the next set of pipeline executions in
#' the list.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_pipeline_executions
codepipeline_list_pipeline_executions <- function(pipelineName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "pipelineExecutionSummaries")
  )
  input <- .codepipeline$list_pipeline_executions_input(pipelineName = pipelineName, maxResults = maxResults, nextToken = nextToken)
  output <- .codepipeline$list_pipeline_executions_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_pipeline_executions <- codepipeline_list_pipeline_executions

#' Gets a summary of all of the pipelines associated with your account
#'
#' @description
#' Gets a summary of all of the pipelines associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_pipelines/](https://www.paws-r-sdk.com/docs/codepipeline_list_pipelines/) for full documentation.
#'
#' @param nextToken An identifier that was returned from the previous list pipelines call.
#' It can be used to return the next set of pipelines in the list.
#' @param maxResults The maximum number of pipelines to return in a single call. To retrieve
#' the remaining pipelines, make another call with the returned nextToken
#' value. The minimum value you can specify is 1. The maximum accepted
#' value is 1000.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_pipelines
codepipeline_list_pipelines <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "pipelines")
  )
  input <- .codepipeline$list_pipelines_input(nextToken = nextToken, maxResults = maxResults)
  output <- .codepipeline$list_pipelines_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_pipelines <- codepipeline_list_pipelines

#' Gets the set of key-value pairs (metadata) that are used to manage the
#' resource
#'
#' @description
#' Gets the set of key-value pairs (metadata) that are used to manage the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codepipeline_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get tags for.
#' @param nextToken The token that was returned from the previous API call, which would be
#' used to return the next page of the list. The ListTagsforResource call
#' lists all available tags in one call and does not use pagination.
#' @param maxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_tags_for_resource
codepipeline_list_tags_for_resource <- function(resourceArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "tags")
  )
  input <- .codepipeline$list_tags_for_resource_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .codepipeline$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_tags_for_resource <- codepipeline_list_tags_for_resource

#' Gets a listing of all the webhooks in this Amazon Web Services Region
#' for this account
#'
#' @description
#' Gets a listing of all the webhooks in this Amazon Web Services Region for this account. The output lists all webhooks and includes the webhook URL and ARN and the configuration for each webhook.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_list_webhooks/](https://www.paws-r-sdk.com/docs/codepipeline_list_webhooks/) for full documentation.
#'
#' @param NextToken The token that was returned from the previous ListWebhooks call, which
#' can be used to return the next set of webhooks in the list.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_webhooks
codepipeline_list_webhooks <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWebhooks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "webhooks")
  )
  input <- .codepipeline$list_webhooks_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .codepipeline$list_webhooks_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_webhooks <- codepipeline_list_webhooks

#' Returns information about any jobs for CodePipeline to act on
#'
#' @description
#' Returns information about any jobs for CodePipeline to act on. [`poll_for_jobs`][codepipeline_poll_for_jobs] is valid only for action types with "Custom" in the owner field. If the action type contains `AWS` or `ThirdParty` in the owner field, the [`poll_for_jobs`][codepipeline_poll_for_jobs] action returns an error.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_poll_for_jobs/](https://www.paws-r-sdk.com/docs/codepipeline_poll_for_jobs/) for full documentation.
#'
#' @param actionTypeId &#91;required&#93; Represents information about an action type.
#' @param maxBatchSize The maximum number of jobs to return in a poll for jobs call.
#' @param queryParam A map of property names and values. For an action type with no queryable
#' properties, this value must be null or an empty map. For an action type
#' with a queryable property, you must supply that property as a key in the
#' map. Only jobs whose action configuration matches the mapped value are
#' returned.
#'
#' @keywords internal
#'
#' @rdname codepipeline_poll_for_jobs
codepipeline_poll_for_jobs <- function(actionTypeId, maxBatchSize = NULL, queryParam = NULL) {
  op <- new_operation(
    name = "PollForJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$poll_for_jobs_input(actionTypeId = actionTypeId, maxBatchSize = maxBatchSize, queryParam = queryParam)
  output <- .codepipeline$poll_for_jobs_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$poll_for_jobs <- codepipeline_poll_for_jobs

#' Determines whether there are any third party jobs for a job worker to
#' act on
#'
#' @description
#' Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_poll_for_third_party_jobs/](https://www.paws-r-sdk.com/docs/codepipeline_poll_for_third_party_jobs/) for full documentation.
#'
#' @param actionTypeId &#91;required&#93; Represents information about an action type.
#' @param maxBatchSize The maximum number of jobs to return in a poll for jobs call.
#'
#' @keywords internal
#'
#' @rdname codepipeline_poll_for_third_party_jobs
codepipeline_poll_for_third_party_jobs <- function(actionTypeId, maxBatchSize = NULL) {
  op <- new_operation(
    name = "PollForThirdPartyJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$poll_for_third_party_jobs_input(actionTypeId = actionTypeId, maxBatchSize = maxBatchSize)
  output <- .codepipeline$poll_for_third_party_jobs_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$poll_for_third_party_jobs <- codepipeline_poll_for_third_party_jobs

#' Provides information to CodePipeline about new revisions to a source
#'
#' @description
#' Provides information to CodePipeline about new revisions to a source.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_action_revision/](https://www.paws-r-sdk.com/docs/codepipeline_put_action_revision/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that starts processing the revision to the
#' source.
#' @param stageName &#91;required&#93; The name of the stage that contains the action that acts on the
#' revision.
#' @param actionName &#91;required&#93; The name of the action that processes the revision.
#' @param actionRevision &#91;required&#93; Represents information about the version (or revision) of an action.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_action_revision
codepipeline_put_action_revision <- function(pipelineName, stageName, actionName, actionRevision) {
  op <- new_operation(
    name = "PutActionRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_action_revision_input(pipelineName = pipelineName, stageName = stageName, actionName = actionName, actionRevision = actionRevision)
  output <- .codepipeline$put_action_revision_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_action_revision <- codepipeline_put_action_revision

#' Provides the response to a manual approval request to CodePipeline
#'
#' @description
#' Provides the response to a manual approval request to CodePipeline. Valid responses include Approved and Rejected.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_approval_result/](https://www.paws-r-sdk.com/docs/codepipeline_put_approval_result/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that contains the action.
#' @param stageName &#91;required&#93; The name of the stage that contains the action.
#' @param actionName &#91;required&#93; The name of the action for which approval is requested.
#' @param result &#91;required&#93; Represents information about the result of the approval request.
#' @param token &#91;required&#93; The system-generated token used to identify a unique approval request.
#' The token for each open approval request can be obtained using the
#' [`get_pipeline_state`][codepipeline_get_pipeline_state] action. It is
#' used to validate that the approval request corresponding to this token
#' is still valid.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_approval_result
codepipeline_put_approval_result <- function(pipelineName, stageName, actionName, result, token) {
  op <- new_operation(
    name = "PutApprovalResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_approval_result_input(pipelineName = pipelineName, stageName = stageName, actionName = actionName, result = result, token = token)
  output <- .codepipeline$put_approval_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_approval_result <- codepipeline_put_approval_result

#' Represents the failure of a job as returned to the pipeline by a job
#' worker
#'
#' @description
#' Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_job_failure_result/](https://www.paws-r-sdk.com/docs/codepipeline_put_job_failure_result/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job that failed. This is the same
#' ID returned from [`poll_for_jobs`][codepipeline_poll_for_jobs].
#' @param failureDetails &#91;required&#93; The details about the failure of a job.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_job_failure_result
codepipeline_put_job_failure_result <- function(jobId, failureDetails) {
  op <- new_operation(
    name = "PutJobFailureResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_job_failure_result_input(jobId = jobId, failureDetails = failureDetails)
  output <- .codepipeline$put_job_failure_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_job_failure_result <- codepipeline_put_job_failure_result

#' Represents the success of a job as returned to the pipeline by a job
#' worker
#'
#' @description
#' Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_job_success_result/](https://www.paws-r-sdk.com/docs/codepipeline_put_job_success_result/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job that succeeded. This is the
#' same ID returned from [`poll_for_jobs`][codepipeline_poll_for_jobs].
#' @param currentRevision The ID of the current revision of the artifact successfully worked on by
#' the job.
#' @param continuationToken A token generated by a job worker, such as a CodeDeploy deployment ID,
#' that a successful job provides to identify a custom action in progress.
#' Future jobs use this token to identify the running instance of the
#' action. It can be reused to return more information about the progress
#' of the custom action. When the action is complete, no continuation token
#' should be supplied.
#' @param executionDetails The execution details of the successful job, such as the actions taken
#' by the job worker.
#' @param outputVariables Key-value pairs produced as output by a job worker that can be made
#' available to a downstream action configuration. `outputVariables` can be
#' included only when there is no continuation token on the request.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_job_success_result
codepipeline_put_job_success_result <- function(jobId, currentRevision = NULL, continuationToken = NULL, executionDetails = NULL, outputVariables = NULL) {
  op <- new_operation(
    name = "PutJobSuccessResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_job_success_result_input(jobId = jobId, currentRevision = currentRevision, continuationToken = continuationToken, executionDetails = executionDetails, outputVariables = outputVariables)
  output <- .codepipeline$put_job_success_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_job_success_result <- codepipeline_put_job_success_result

#' Represents the failure of a third party job as returned to the pipeline
#' by a job worker
#'
#' @description
#' Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_third_party_job_failure_result/](https://www.paws-r-sdk.com/docs/codepipeline_put_third_party_job_failure_result/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the job that failed. This is the same ID returned from
#' [`poll_for_third_party_jobs`][codepipeline_poll_for_third_party_jobs].
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#' @param failureDetails &#91;required&#93; Represents information about failure details.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_third_party_job_failure_result
codepipeline_put_third_party_job_failure_result <- function(jobId, clientToken, failureDetails) {
  op <- new_operation(
    name = "PutThirdPartyJobFailureResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_third_party_job_failure_result_input(jobId = jobId, clientToken = clientToken, failureDetails = failureDetails)
  output <- .codepipeline$put_third_party_job_failure_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_third_party_job_failure_result <- codepipeline_put_third_party_job_failure_result

#' Represents the success of a third party job as returned to the pipeline
#' by a job worker
#'
#' @description
#' Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_third_party_job_success_result/](https://www.paws-r-sdk.com/docs/codepipeline_put_third_party_job_success_result/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the job that successfully completed. This is the same ID
#' returned from
#' [`poll_for_third_party_jobs`][codepipeline_poll_for_third_party_jobs].
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#' @param currentRevision Represents information about a current revision.
#' @param continuationToken A token generated by a job worker, such as a CodeDeploy deployment ID,
#' that a successful job provides to identify a partner action in progress.
#' Future jobs use this token to identify the running instance of the
#' action. It can be reused to return more information about the progress
#' of the partner action. When the action is complete, no continuation
#' token should be supplied.
#' @param executionDetails The details of the actions taken and results produced on an artifact as
#' it passes through stages in the pipeline.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_third_party_job_success_result
codepipeline_put_third_party_job_success_result <- function(jobId, clientToken, currentRevision = NULL, continuationToken = NULL, executionDetails = NULL) {
  op <- new_operation(
    name = "PutThirdPartyJobSuccessResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_third_party_job_success_result_input(jobId = jobId, clientToken = clientToken, currentRevision = currentRevision, continuationToken = continuationToken, executionDetails = executionDetails)
  output <- .codepipeline$put_third_party_job_success_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_third_party_job_success_result <- codepipeline_put_third_party_job_success_result

#' Defines a webhook and returns a unique webhook URL generated by
#' CodePipeline
#'
#' @description
#' Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third party source hosting providers to call every time there's a code change. When CodePipeline receives a POST request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the generated webhook URL.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_put_webhook/](https://www.paws-r-sdk.com/docs/codepipeline_put_webhook/) for full documentation.
#'
#' @param webhook &#91;required&#93; The detail provided in an input file to create the webhook, such as the
#' webhook name, the pipeline name, and the action name. Give the webhook a
#' unique name that helps you identify it. You might name the webhook after
#' the pipeline and action it targets so that you can easily recognize what
#' it's used for later.
#' @param tags The tags for the webhook.
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_webhook
codepipeline_put_webhook <- function(webhook, tags = NULL) {
  op <- new_operation(
    name = "PutWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_webhook_input(webhook = webhook, tags = tags)
  output <- .codepipeline$put_webhook_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_webhook <- codepipeline_put_webhook

#' Configures a connection between the webhook that was created and the
#' external tool with events to be detected
#'
#' @description
#' Configures a connection between the webhook that was created and the external tool with events to be detected.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_register_webhook_with_third_party/](https://www.paws-r-sdk.com/docs/codepipeline_register_webhook_with_third_party/) for full documentation.
#'
#' @param webhookName The name of an existing webhook created with PutWebhook to register with
#' a supported third party.
#'
#' @keywords internal
#'
#' @rdname codepipeline_register_webhook_with_third_party
codepipeline_register_webhook_with_third_party <- function(webhookName = NULL) {
  op <- new_operation(
    name = "RegisterWebhookWithThirdParty",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$register_webhook_with_third_party_input(webhookName = webhookName)
  output <- .codepipeline$register_webhook_with_third_party_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$register_webhook_with_third_party <- codepipeline_register_webhook_with_third_party

#' You can retry a stage that has failed without having to run a pipeline
#' again from the beginning
#'
#' @description
#' You can retry a stage that has failed without having to run a pipeline again from the beginning. You do this by either retrying the failed actions in a stage or by retrying all actions in the stage starting from the first action in the stage. When you retry the failed actions in a stage, all actions that are still in progress continue working, and failed actions are triggered again. When you retry a failed stage from the first action in the stage, the stage cannot have any actions in progress. Before a stage can be retried, it must either have all actions failed or some actions failed and some succeeded.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_retry_stage_execution/](https://www.paws-r-sdk.com/docs/codepipeline_retry_stage_execution/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that contains the failed stage.
#' @param stageName &#91;required&#93; The name of the failed stage to be retried.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution in the failed stage to be retried. Use
#' the [`get_pipeline_state`][codepipeline_get_pipeline_state] action to
#' retrieve the current pipelineExecutionId of the failed stage
#' @param retryMode &#91;required&#93; The scope of the retry attempt.
#'
#' @keywords internal
#'
#' @rdname codepipeline_retry_stage_execution
codepipeline_retry_stage_execution <- function(pipelineName, stageName, pipelineExecutionId, retryMode) {
  op <- new_operation(
    name = "RetryStageExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$retry_stage_execution_input(pipelineName = pipelineName, stageName = stageName, pipelineExecutionId = pipelineExecutionId, retryMode = retryMode)
  output <- .codepipeline$retry_stage_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$retry_stage_execution <- codepipeline_retry_stage_execution

#' Starts the specified pipeline
#'
#' @description
#' Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_start_pipeline_execution/](https://www.paws-r-sdk.com/docs/codepipeline_start_pipeline_execution/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the pipeline to start.
#' @param variables A list that overrides pipeline variables for a pipeline execution that's
#' being started. Variable names must match `[A-Za-z0-9@@\-_]+`, and the
#' values can be anything except an empty string.
#' @param clientRequestToken The system-generated unique ID used to identify a unique execution
#' request.
#' @param sourceRevisions A list that allows you to specify, or override, the source revision for
#' a pipeline execution that's being started. A source revision is the
#' version with all the changes to your application code, or source
#' artifact, for the pipeline execution.
#'
#' @keywords internal
#'
#' @rdname codepipeline_start_pipeline_execution
codepipeline_start_pipeline_execution <- function(name, variables = NULL, clientRequestToken = NULL, sourceRevisions = NULL) {
  op <- new_operation(
    name = "StartPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$start_pipeline_execution_input(name = name, variables = variables, clientRequestToken = clientRequestToken, sourceRevisions = sourceRevisions)
  output <- .codepipeline$start_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$start_pipeline_execution <- codepipeline_start_pipeline_execution

#' Stops the specified pipeline execution
#'
#' @description
#' Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing or abandoning in-progress actions, the pipeline execution is in a `Stopping` state. After all in-progress actions are completed or abandoned, the pipeline execution is in a `Stopped` state.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_stop_pipeline_execution/](https://www.paws-r-sdk.com/docs/codepipeline_stop_pipeline_execution/) for full documentation.
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline to stop.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution to be stopped in the current stage. Use
#' the [`get_pipeline_state`][codepipeline_get_pipeline_state] action to
#' retrieve the current pipelineExecutionId.
#' @param abandon Use this option to stop the pipeline execution by abandoning, rather
#' than finishing, in-progress actions.
#' 
#' This option can lead to failed or out-of-sequence tasks.
#' @param reason Use this option to enter comments, such as the reason the pipeline was
#' stopped.
#'
#' @keywords internal
#'
#' @rdname codepipeline_stop_pipeline_execution
codepipeline_stop_pipeline_execution <- function(pipelineName, pipelineExecutionId, abandon = NULL, reason = NULL) {
  op <- new_operation(
    name = "StopPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$stop_pipeline_execution_input(pipelineName = pipelineName, pipelineExecutionId = pipelineExecutionId, abandon = abandon, reason = reason)
  output <- .codepipeline$stop_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$stop_pipeline_execution <- codepipeline_stop_pipeline_execution

#' Adds to or modifies the tags of the given resource
#'
#' @description
#' Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_tag_resource/](https://www.paws-r-sdk.com/docs/codepipeline_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to add tags to.
#' @param tags &#91;required&#93; The tags you want to modify or add to the resource.
#'
#' @keywords internal
#'
#' @rdname codepipeline_tag_resource
codepipeline_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codepipeline$tag_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$tag_resource <- codepipeline_tag_resource

#' Removes tags from an Amazon Web Services resource
#'
#' @description
#' Removes tags from an Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_untag_resource/](https://www.paws-r-sdk.com/docs/codepipeline_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from.
#' @param tagKeys &#91;required&#93; The list of keys for the tags to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname codepipeline_untag_resource
codepipeline_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codepipeline$untag_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$untag_resource <- codepipeline_untag_resource

#' Updates an action type that was created with any supported integration
#' model, where the action type is to be used by customers of the action
#' type provider
#'
#' @description
#' Updates an action type that was created with any supported integration model, where the action type is to be used by customers of the action type provider. Use a JSON file with the action definition and [`update_action_type`][codepipeline_update_action_type] to provide the full structure.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_update_action_type/](https://www.paws-r-sdk.com/docs/codepipeline_update_action_type/) for full documentation.
#'
#' @param actionType &#91;required&#93; The action type definition for the action type to be updated.
#'
#' @keywords internal
#'
#' @rdname codepipeline_update_action_type
codepipeline_update_action_type <- function(actionType) {
  op <- new_operation(
    name = "UpdateActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$update_action_type_input(actionType = actionType)
  output <- .codepipeline$update_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$update_action_type <- codepipeline_update_action_type

#' Updates a specified pipeline with edits or changes to its structure
#'
#' @description
#' Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure and [`update_pipeline`][codepipeline_update_pipeline] to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.
#'
#' See [https://www.paws-r-sdk.com/docs/codepipeline_update_pipeline/](https://www.paws-r-sdk.com/docs/codepipeline_update_pipeline/) for full documentation.
#'
#' @param pipeline &#91;required&#93; The name of the pipeline to be updated.
#'
#' @keywords internal
#'
#' @rdname codepipeline_update_pipeline
codepipeline_update_pipeline <- function(pipeline) {
  op <- new_operation(
    name = "UpdatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$update_pipeline_input(pipeline = pipeline)
  output <- .codepipeline$update_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$update_pipeline <- codepipeline_update_pipeline
