% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_get_trace_summaries}
\alias{xray_get_trace_summaries}
\title{Retrieves IDs and annotations for traces available for a specified time
frame using an optional filter}
\usage{
xray_get_trace_summaries(
  StartTime,
  EndTime,
  TimeRangeType = NULL,
  Sampling = NULL,
  SamplingStrategy = NULL,
  FilterExpression = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartTime}{[required] The start of the time frame for which to retrieve traces.}

\item{EndTime}{[required] The end of the time frame for which to retrieve traces.}

\item{TimeRangeType}{A parameter to indicate whether to query trace summaries by TraceId or
Event time.}

\item{Sampling}{Set to \code{true} to get summaries for only a subset of available traces.}

\item{SamplingStrategy}{A parameter to indicate whether to enable sampling on trace summaries.
Input parameters are Name and Value.}

\item{FilterExpression}{Specify a filter expression to retrieve trace summaries for services or
requests that meet certain requirements.}

\item{NextToken}{Specify the pagination token returned by a previous request to retrieve
the next page of results.}
}
\description{
Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to \code{\link[=xray_batch_get_traces]{batch_get_traces}}.

See \url{https://www.paws-r-sdk.com/docs/xray_get_trace_summaries/} for full documentation.
}
\keyword{internal}
