% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_update_approval_rule_template_content}
\alias{codecommit_update_approval_rule_template_content}
\title{Updates the content of an approval rule template}
\usage{
codecommit_update_approval_rule_template_content(
  approvalRuleTemplateName,
  newRuleContent,
  existingRuleContentSha256 = NULL
)
}
\arguments{
\item{approvalRuleTemplateName}{[required] The name of the approval rule template where you want to update the
content of the rule.}

\item{newRuleContent}{[required] The content that replaces the existing content of the rule. Content
statements must be complete. You cannot provide only the changes.}

\item{existingRuleContentSha256}{The SHA-256 hash signature for the content of the approval rule. You can
retrieve this information by using
\code{\link[=codecommit_get_pull_request]{get_pull_request}}.}
}
\description{
Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.

See \url{https://paws-r.github.io/docs/codecommit/update_approval_rule_template_content.html} for full documentation.
}
\keyword{internal}
