% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_merge_commit}
\alias{codecommit_get_merge_commit}
\title{Returns information about a specified merge commit}
\usage{
codecommit_get_merge_commit(
  repositoryName,
  sourceCommitSpecifier,
  destinationCommitSpecifier,
  conflictDetailLevel = NULL,
  conflictResolutionStrategy = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository that contains the merge commit about which
you want to get information.}

\item{sourceCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{destinationCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{conflictDetailLevel}{The level of conflict detail to use. If unspecified, the default
FILE_LEVEL is used, which returns a not-mergeable result if the same
file has differences in both branches. If LINE_LEVEL is specified, a
conflict is considered not mergeable if the same file in both branches
has differences on the same line.}

\item{conflictResolutionStrategy}{Specifies which branch to use when resolving conflicts, or whether to
attempt automatically merging two versions of a file. The default is
NONE, which requires any conflicts to be resolved manually before the
merge operation is successful.}
}
\description{
Returns information about a specified merge commit.

See \url{https://paws-r.github.io/docs/codecommit/get_merge_commit.html} for full documentation.
}
\keyword{internal}
