% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_describe_pull_request_events}
\alias{codecommit_describe_pull_request_events}
\title{Returns information about one or more pull request events}
\usage{
codecommit_describe_pull_request_events(
  pullRequestId,
  pullRequestEventType = NULL,
  actorArn = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{pullRequestEventType}{Optional. The pull request event type about which you want to return
information.}

\item{actorArn}{The Amazon Resource Name (ARN) of the user whose actions resulted in the
event. Examples include updating the pull request with more commits or
changing the status of a pull request.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results. The default is 100 events, which is also the maximum number of
events that can be returned in a result.}
}
\description{
Returns information about one or more pull request events.

See \url{https://paws-r.github.io/docs/codecommit/describe_pull_request_events.html} for full documentation.
}
\keyword{internal}
