% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_register_application_revision}
\alias{codedeploy_register_application_revision}
\title{Registers with AWS CodeDeploy a revision for the specified application}
\usage{
codedeploy_register_application_revision(applicationName, description,
  revision)
}
\arguments{
\item{applicationName}{[required] The name of an AWS CodeDeploy application associated with the IAM user
or AWS account.}

\item{description}{A comment about the revision.}

\item{revision}{[required] Information about the application revision to register, including type
and location.}
}
\value{
An empty list.
}
\description{
Registers with AWS CodeDeploy a revision for the specified application.
}
\section{Request syntax}{
\preformatted{svc$register_application_revision(
  applicationName = "string",
  description = "string",
  revision = list(
    revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
    s3Location = list(
      bucket = "string",
      key = "string",
      bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
      version = "string",
      eTag = "string"
    ),
    gitHubLocation = list(
      repository = "string",
      commitId = "string"
    ),
    string = list(
      content = "string",
      sha256 = "string"
    ),
    appSpecContent = list(
      content = "string",
      sha256 = "string"
    )
  )
)
}
}

\keyword{internal}
