% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdbelastic_operations.R
\name{docdbelastic_update_cluster}
\alias{docdbelastic_update_cluster}
\title{Modifies a Elastic DocumentDB cluster}
\usage{
docdbelastic_update_cluster(
  adminUserPassword = NULL,
  authType = NULL,
  clientToken = NULL,
  clusterArn,
  preferredMaintenanceWindow = NULL,
  shardCapacity = NULL,
  shardCount = NULL,
  subnetIds = NULL,
  vpcSecurityGroupIds = NULL
)
}
\arguments{
\item{adminUserPassword}{The password for the Elastic DocumentDB cluster administrator. This
password can contain any printable ASCII character except forward slash
(/), double quote ("), or the "at" symbol (@).

\emph{Constraints}: Must contain from 8 to 100 characters.}

\item{authType}{The authentication type for the Elastic DocumentDB cluster.}

\item{clientToken}{The client token for the Elastic DocumentDB cluster.}

\item{clusterArn}{[required] The arn of the Elastic DocumentDB cluster.}

\item{preferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

\emph{Format}: \code{ddd:hh24:mi-ddd:hh24:mi}

\emph{Default}: a 30-minute window selected at random from an 8-hour block of
time for each Amazon Web Services Region, occurring on a random day of
the week.

\emph{Valid days}: Mon, Tue, Wed, Thu, Fri, Sat, Sun

\emph{Constraints}: Minimum 30-minute window.}

\item{shardCapacity}{The capacity of each shard in the Elastic DocumentDB cluster.}

\item{shardCount}{The number of shards to create in the Elastic DocumentDB cluster.}

\item{subnetIds}{The number of shards to create in the Elastic DocumentDB cluster.}

\item{vpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the new Elastic
DocumentDB cluster.}
}
\description{
Modifies a Elastic DocumentDB cluster. This includes updating admin-username/password, upgrading API version setting up a backup window and maintenance window

See \url{https://www.paws-r-sdk.com/docs/docdbelastic_update_cluster/} for full documentation.
}
\keyword{internal}
