# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include redshiftserverless_service.R
NULL

#' Converts a recovery point to a snapshot
#'
#' @description
#' Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/).
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_convert_recovery_point_to_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_convert_recovery_point_to_snapshot/) for full documentation.
#'
#' @param recoveryPointId &#91;required&#93; The unique identifier of the recovery point.
#' @param retentionPeriod How long to retain the snapshot.
#' @param snapshotName &#91;required&#93; The name of the snapshot.
#' @param tags An array of [Tag
#' objects](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
#' to associate with the created snapshot.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_convert_recovery_point_to_snapshot
redshiftserverless_convert_recovery_point_to_snapshot <- function(recoveryPointId, retentionPeriod = NULL, snapshotName, tags = NULL) {
  op <- new_operation(
    name = "ConvertRecoveryPointToSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$convert_recovery_point_to_snapshot_input(recoveryPointId = recoveryPointId, retentionPeriod = retentionPeriod, snapshotName = snapshotName, tags = tags)
  output <- .redshiftserverless$convert_recovery_point_to_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$convert_recovery_point_to_snapshot <- redshiftserverless_convert_recovery_point_to_snapshot

#' Creates a custom domain association for Amazon Redshift Serverless
#'
#' @description
#' Creates a custom domain association for Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_custom_domain_association/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_custom_domain_association/) for full documentation.
#'
#' @param customDomainCertificateArn &#91;required&#93; The custom domain name’s certificate Amazon resource name (ARN).
#' @param customDomainName &#91;required&#93; The custom domain name to associate with the workgroup.
#' @param workgroupName &#91;required&#93; The name of the workgroup associated with the database.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_custom_domain_association
redshiftserverless_create_custom_domain_association <- function(customDomainCertificateArn, customDomainName, workgroupName) {
  op <- new_operation(
    name = "CreateCustomDomainAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_custom_domain_association_input(customDomainCertificateArn = customDomainCertificateArn, customDomainName = customDomainName, workgroupName = workgroupName)
  output <- .redshiftserverless$create_custom_domain_association_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_custom_domain_association <- redshiftserverless_create_custom_domain_association

#' Creates an Amazon Redshift Serverless managed VPC endpoint
#'
#' @description
#' Creates an Amazon Redshift Serverless managed VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_endpoint_access/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_endpoint_access/) for full documentation.
#'
#' @param endpointName &#91;required&#93; The name of the VPC endpoint. An endpoint name must contain 1-30
#' characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first
#' character must be a letter. The name can't contain two consecutive
#' hyphens or end with a hyphen.
#' @param ownerAccount The owner Amazon Web Services account for the Amazon Redshift Serverless
#' workgroup.
#' @param subnetIds &#91;required&#93; The unique identifers of subnets from which Amazon Redshift Serverless
#' chooses one to deploy a VPC endpoint.
#' @param vpcSecurityGroupIds The unique identifiers of the security group that defines the ports,
#' protocols, and sources for inbound traffic that you are authorizing into
#' your endpoint.
#' @param workgroupName &#91;required&#93; The name of the workgroup to associate with the VPC endpoint.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_endpoint_access
redshiftserverless_create_endpoint_access <- function(endpointName, ownerAccount = NULL, subnetIds, vpcSecurityGroupIds = NULL, workgroupName) {
  op <- new_operation(
    name = "CreateEndpointAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_endpoint_access_input(endpointName = endpointName, ownerAccount = ownerAccount, subnetIds = subnetIds, vpcSecurityGroupIds = vpcSecurityGroupIds, workgroupName = workgroupName)
  output <- .redshiftserverless$create_endpoint_access_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_endpoint_access <- redshiftserverless_create_endpoint_access

#' Creates a namespace in Amazon Redshift Serverless
#'
#' @description
#' Creates a namespace in Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_namespace/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_namespace/) for full documentation.
#'
#' @param adminPasswordSecretKmsKeyId The ID of the Key Management Service (KMS) key used to encrypt and store
#' the namespace's admin credentials secret. You can only use this
#' parameter if `manageAdminPassword` is true.
#' @param adminUserPassword The password of the administrator for the first database created in the
#' namespace.
#' 
#' You can't use `adminUserPassword` if `manageAdminPassword` is true.
#' @param adminUsername The username of the administrator for the first database created in the
#' namespace.
#' @param dbName The name of the first database created in the namespace.
#' @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in
#' the namespace.
#' @param iamRoles A list of IAM roles to associate with the namespace.
#' @param kmsKeyId The ID of the Amazon Web Services Key Management Service key used to
#' encrypt your data.
#' @param logExports The types of logs the namespace can export. Available export types are
#' `userlog`, `connectionlog`, and `useractivitylog`.
#' @param manageAdminPassword If `true`, Amazon Redshift uses Secrets Manager to manage the
#' namespace's admin credentials. You can't use `adminUserPassword` if
#' `manageAdminPassword` is true. If `manageAdminPassword` is false or not
#' set, Amazon Redshift uses `adminUserPassword` for the admin user
#' account's password.
#' @param namespaceName &#91;required&#93; The name of the namespace.
#' @param redshiftIdcApplicationArn The ARN for the Redshift application that integrates with IAM Identity
#' Center.
#' @param tags A list of tag instances.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_namespace
redshiftserverless_create_namespace <- function(adminPasswordSecretKmsKeyId = NULL, adminUserPassword = NULL, adminUsername = NULL, dbName = NULL, defaultIamRoleArn = NULL, iamRoles = NULL, kmsKeyId = NULL, logExports = NULL, manageAdminPassword = NULL, namespaceName, redshiftIdcApplicationArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_namespace_input(adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId, adminUserPassword = adminUserPassword, adminUsername = adminUsername, dbName = dbName, defaultIamRoleArn = defaultIamRoleArn, iamRoles = iamRoles, kmsKeyId = kmsKeyId, logExports = logExports, manageAdminPassword = manageAdminPassword, namespaceName = namespaceName, redshiftIdcApplicationArn = redshiftIdcApplicationArn, tags = tags)
  output <- .redshiftserverless$create_namespace_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_namespace <- redshiftserverless_create_namespace

#' Creates a scheduled action
#'
#' @description
#' Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the [`create_snapshot`][redshiftserverless_create_snapshot] API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_scheduled_action/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_scheduled_action/) for full documentation.
#'
#' @param enabled Indicates whether the schedule is enabled. If false, the scheduled
#' action does not trigger. For more information about `state` of the
#' scheduled action, see
#' [ScheduledAction](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/).
#' @param endTime The end time in UTC when the schedule is no longer active. After this
#' time, the scheduled action does not trigger.
#' @param namespaceName &#91;required&#93; The name of the namespace for which to create a scheduled action.
#' @param roleArn &#91;required&#93; The ARN of the IAM role to assume to run the scheduled action. This IAM
#' role must have permission to run the Amazon Redshift Serverless API
#' operation in the scheduled action. This IAM role must allow the Amazon
#' Redshift scheduler to schedule creating snapshots. (Principal
#' scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
#' For more information about the IAM role to use with the Amazon Redshift
#' scheduler, see [Using Identity-Based Policies for Amazon
#' Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
#' in the Amazon Redshift Cluster Management Guide
#' @param schedule &#91;required&#93; The schedule for a one-time (at format) or recurring (cron format)
#' scheduled action. Schedule invocations must be separated by at least one
#' hour.
#' 
#' Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example,
#' "`at(2016-03-04T17:27:00)`".
#' 
#' Format of cron expressions is
#' "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For
#' example, "`cron(0 10 ? * MON *)`". For more information, see [Cron
#' Expressions](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html#CronExpressions)
#' in the *Amazon CloudWatch Events User Guide*.
#' @param scheduledActionDescription The description of the scheduled action.
#' @param scheduledActionName &#91;required&#93; The name of the scheduled action.
#' @param startTime The start time in UTC when the schedule is active. Before this time, the
#' scheduled action does not trigger.
#' @param targetAction &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_scheduled_action
redshiftserverless_create_scheduled_action <- function(enabled = NULL, endTime = NULL, namespaceName, roleArn, schedule, scheduledActionDescription = NULL, scheduledActionName, startTime = NULL, targetAction) {
  op <- new_operation(
    name = "CreateScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_scheduled_action_input(enabled = enabled, endTime = endTime, namespaceName = namespaceName, roleArn = roleArn, schedule = schedule, scheduledActionDescription = scheduledActionDescription, scheduledActionName = scheduledActionName, startTime = startTime, targetAction = targetAction)
  output <- .redshiftserverless$create_scheduled_action_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_scheduled_action <- redshiftserverless_create_scheduled_action

#' Creates a snapshot of all databases in a namespace
#'
#' @description
#' Creates a snapshot of all databases in a namespace. For more information about snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/).
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_snapshot/) for full documentation.
#'
#' @param namespaceName &#91;required&#93; The namespace to create a snapshot for.
#' @param retentionPeriod How long to retain the created snapshot.
#' @param snapshotName &#91;required&#93; The name of the snapshot.
#' @param tags An array of [Tag
#' objects](https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
#' to associate with the snapshot.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_snapshot
redshiftserverless_create_snapshot <- function(namespaceName, retentionPeriod = NULL, snapshotName, tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_snapshot_input(namespaceName = namespaceName, retentionPeriod = retentionPeriod, snapshotName = snapshotName, tags = tags)
  output <- .redshiftserverless$create_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_snapshot <- redshiftserverless_create_snapshot

#' Creates a snapshot copy configuration that lets you copy snapshots to
#' another Amazon Web Services Region
#'
#' @description
#' Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_snapshot_copy_configuration/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_snapshot_copy_configuration/) for full documentation.
#'
#' @param destinationKmsKeyId The KMS key to use to encrypt your snapshots in the destination Amazon
#' Web Services Region.
#' @param destinationRegion &#91;required&#93; The destination Amazon Web Services Region that you want to copy
#' snapshots to.
#' @param namespaceName &#91;required&#93; The name of the namespace to copy snapshots from.
#' @param snapshotRetentionPeriod The retention period of the snapshots that you copy to the destination
#' Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_snapshot_copy_configuration
redshiftserverless_create_snapshot_copy_configuration <- function(destinationKmsKeyId = NULL, destinationRegion, namespaceName, snapshotRetentionPeriod = NULL) {
  op <- new_operation(
    name = "CreateSnapshotCopyConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_snapshot_copy_configuration_input(destinationKmsKeyId = destinationKmsKeyId, destinationRegion = destinationRegion, namespaceName = namespaceName, snapshotRetentionPeriod = snapshotRetentionPeriod)
  output <- .redshiftserverless$create_snapshot_copy_configuration_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_snapshot_copy_configuration <- redshiftserverless_create_snapshot_copy_configuration

#' Creates a usage limit for a specified Amazon Redshift Serverless usage
#' type
#'
#' @description
#' Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_usage_limit/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_usage_limit/) for full documentation.
#'
#' @param amount &#91;required&#93; The limit amount. If time-based, this amount is in Redshift Processing
#' Units (RPU) consumed per hour. If data-based, this amount is in
#' terabytes (TB) of data transferred between Regions in cross-account
#' sharing. The value must be a positive number.
#' @param breachAction The action that Amazon Redshift Serverless takes when the limit is
#' reached. The default is log.
#' @param period The time period that the amount applies to. A weekly period begins on
#' Sunday. The default is monthly.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Redshift Serverless
#' resource to create the usage limit for.
#' @param usageType &#91;required&#93; The type of Amazon Redshift Serverless usage to create a usage limit
#' for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_usage_limit
redshiftserverless_create_usage_limit <- function(amount, breachAction = NULL, period = NULL, resourceArn, usageType) {
  op <- new_operation(
    name = "CreateUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_usage_limit_input(amount = amount, breachAction = breachAction, period = period, resourceArn = resourceArn, usageType = usageType)
  output <- .redshiftserverless$create_usage_limit_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_usage_limit <- redshiftserverless_create_usage_limit

#' Creates an workgroup in Amazon Redshift Serverless
#'
#' @description
#' Creates an workgroup in Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_create_workgroup/](https://www.paws-r-sdk.com/docs/redshiftserverless_create_workgroup/) for full documentation.
#'
#' @param baseCapacity The base data warehouse capacity of the workgroup in Redshift Processing
#' Units (RPUs).
#' @param configParameters An array of parameters to set for advanced control over a database. The
#' options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`,
#' `enable_user_activity_logging`, `query_group`, `search_path`, and query
#' monitoring metrics that let you define performance boundaries. For more
#' information about query monitoring rules and available metrics, see
#' [Query monitoring metrics for Amazon Redshift
#' Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
#' @param enhancedVpcRouting The value that specifies whether to turn on enhanced virtual private
#' cloud (VPC) routing, which forces Amazon Redshift Serverless to route
#' traffic through your VPC instead of over the internet.
#' @param maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to
#' serve queries. The max capacity is specified in RPUs.
#' @param namespaceName &#91;required&#93; The name of the namespace to associate with the workgroup.
#' @param port The custom port to use when connecting to a workgroup. Valid port ranges
#' are 5431-5455 and 8191-8215. The default is 5439.
#' @param publiclyAccessible A value that specifies whether the workgroup can be accessed from a
#' public network.
#' @param securityGroupIds An array of security group IDs to associate with the workgroup.
#' @param subnetIds An array of VPC subnet IDs to associate with the workgroup.
#' @param tags A array of tag instances.
#' @param workgroupName &#91;required&#93; The name of the created workgroup.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_create_workgroup
redshiftserverless_create_workgroup <- function(baseCapacity = NULL, configParameters = NULL, enhancedVpcRouting = NULL, maxCapacity = NULL, namespaceName, port = NULL, publiclyAccessible = NULL, securityGroupIds = NULL, subnetIds = NULL, tags = NULL, workgroupName) {
  op <- new_operation(
    name = "CreateWorkgroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$create_workgroup_input(baseCapacity = baseCapacity, configParameters = configParameters, enhancedVpcRouting = enhancedVpcRouting, maxCapacity = maxCapacity, namespaceName = namespaceName, port = port, publiclyAccessible = publiclyAccessible, securityGroupIds = securityGroupIds, subnetIds = subnetIds, tags = tags, workgroupName = workgroupName)
  output <- .redshiftserverless$create_workgroup_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$create_workgroup <- redshiftserverless_create_workgroup

#' Deletes a custom domain association for Amazon Redshift Serverless
#'
#' @description
#' Deletes a custom domain association for Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_custom_domain_association/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_custom_domain_association/) for full documentation.
#'
#' @param customDomainName &#91;required&#93; The custom domain name associated with the workgroup.
#' @param workgroupName &#91;required&#93; The name of the workgroup associated with the database.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_custom_domain_association
redshiftserverless_delete_custom_domain_association <- function(customDomainName, workgroupName) {
  op <- new_operation(
    name = "DeleteCustomDomainAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_custom_domain_association_input(customDomainName = customDomainName, workgroupName = workgroupName)
  output <- .redshiftserverless$delete_custom_domain_association_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_custom_domain_association <- redshiftserverless_delete_custom_domain_association

#' Deletes an Amazon Redshift Serverless managed VPC endpoint
#'
#' @description
#' Deletes an Amazon Redshift Serverless managed VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_endpoint_access/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_endpoint_access/) for full documentation.
#'
#' @param endpointName &#91;required&#93; The name of the VPC endpoint to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_endpoint_access
redshiftserverless_delete_endpoint_access <- function(endpointName) {
  op <- new_operation(
    name = "DeleteEndpointAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_endpoint_access_input(endpointName = endpointName)
  output <- .redshiftserverless$delete_endpoint_access_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_endpoint_access <- redshiftserverless_delete_endpoint_access

#' Deletes a namespace from Amazon Redshift Serverless
#'
#' @description
#' Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_namespace/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_namespace/) for full documentation.
#'
#' @param finalSnapshotName The name of the snapshot to be created before the namespace is deleted.
#' @param finalSnapshotRetentionPeriod How long to retain the final snapshot.
#' @param namespaceName &#91;required&#93; The name of the namespace to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_namespace
redshiftserverless_delete_namespace <- function(finalSnapshotName = NULL, finalSnapshotRetentionPeriod = NULL, namespaceName) {
  op <- new_operation(
    name = "DeleteNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_namespace_input(finalSnapshotName = finalSnapshotName, finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod, namespaceName = namespaceName)
  output <- .redshiftserverless$delete_namespace_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_namespace <- redshiftserverless_delete_namespace

#' Deletes the specified resource policy
#'
#' @description
#' Deletes the specified resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_resource_policy/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the policy to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_resource_policy
redshiftserverless_delete_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_resource_policy_input(resourceArn = resourceArn)
  output <- .redshiftserverless$delete_resource_policy_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_resource_policy <- redshiftserverless_delete_resource_policy

#' Deletes a scheduled action
#'
#' @description
#' Deletes a scheduled action.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_scheduled_action/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_scheduled_action/) for full documentation.
#'
#' @param scheduledActionName &#91;required&#93; The name of the scheduled action to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_scheduled_action
redshiftserverless_delete_scheduled_action <- function(scheduledActionName) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_scheduled_action_input(scheduledActionName = scheduledActionName)
  output <- .redshiftserverless$delete_scheduled_action_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_scheduled_action <- redshiftserverless_delete_scheduled_action

#' Deletes a snapshot from Amazon Redshift Serverless
#'
#' @description
#' Deletes a snapshot from Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_snapshot/) for full documentation.
#'
#' @param snapshotName &#91;required&#93; The name of the snapshot to be deleted.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_snapshot
redshiftserverless_delete_snapshot <- function(snapshotName) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_snapshot_input(snapshotName = snapshotName)
  output <- .redshiftserverless$delete_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_snapshot <- redshiftserverless_delete_snapshot

#' Deletes a snapshot copy configuration
#'
#' @description
#' Deletes a snapshot copy configuration
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_snapshot_copy_configuration/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_snapshot_copy_configuration/) for full documentation.
#'
#' @param snapshotCopyConfigurationId &#91;required&#93; The ID of the snapshot copy configuration to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_snapshot_copy_configuration
redshiftserverless_delete_snapshot_copy_configuration <- function(snapshotCopyConfigurationId) {
  op <- new_operation(
    name = "DeleteSnapshotCopyConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_snapshot_copy_configuration_input(snapshotCopyConfigurationId = snapshotCopyConfigurationId)
  output <- .redshiftserverless$delete_snapshot_copy_configuration_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_snapshot_copy_configuration <- redshiftserverless_delete_snapshot_copy_configuration

#' Deletes a usage limit from Amazon Redshift Serverless
#'
#' @description
#' Deletes a usage limit from Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_usage_limit/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_usage_limit/) for full documentation.
#'
#' @param usageLimitId &#91;required&#93; The unique identifier of the usage limit to delete.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_usage_limit
redshiftserverless_delete_usage_limit <- function(usageLimitId) {
  op <- new_operation(
    name = "DeleteUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_usage_limit_input(usageLimitId = usageLimitId)
  output <- .redshiftserverless$delete_usage_limit_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_usage_limit <- redshiftserverless_delete_usage_limit

#' Deletes a workgroup
#'
#' @description
#' Deletes a workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_delete_workgroup/](https://www.paws-r-sdk.com/docs/redshiftserverless_delete_workgroup/) for full documentation.
#'
#' @param workgroupName &#91;required&#93; The name of the workgroup to be deleted.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_delete_workgroup
redshiftserverless_delete_workgroup <- function(workgroupName) {
  op <- new_operation(
    name = "DeleteWorkgroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$delete_workgroup_input(workgroupName = workgroupName)
  output <- .redshiftserverless$delete_workgroup_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$delete_workgroup <- redshiftserverless_delete_workgroup

#' Returns a database user name and temporary password with temporary
#' authorization to log in to Amazon Redshift Serverless
#'
#' @description
#' Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_credentials/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_credentials/) for full documentation.
#'
#' @param customDomainName The custom domain name associated with the workgroup. The custom domain
#' name or the workgroup name must be included in the request.
#' @param dbName The name of the database to get temporary authorization to log on to.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 64 alphanumeric characters or hyphens.
#' 
#' -   Must contain only uppercase or lowercase letters, numbers,
#'     underscore, plus sign, period (dot), at symbol (@@), or hyphen.
#' 
#' -   The first character must be a letter.
#' 
#' -   Must not contain a colon ( : ) or slash ( / ).
#' 
#' -   Cannot be a reserved word. A list of reserved words can be found in
#'     [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide
#' @param durationSeconds The number of seconds until the returned temporary password expires. The
#' minimum is 900 seconds, and the maximum is 3600 seconds.
#' @param workgroupName The name of the workgroup associated with the database.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_credentials
redshiftserverless_get_credentials <- function(customDomainName = NULL, dbName = NULL, durationSeconds = NULL, workgroupName = NULL) {
  op <- new_operation(
    name = "GetCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_credentials_input(customDomainName = customDomainName, dbName = dbName, durationSeconds = durationSeconds, workgroupName = workgroupName)
  output <- .redshiftserverless$get_credentials_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_credentials <- redshiftserverless_get_credentials

#' Gets information about a specific custom domain association
#'
#' @description
#' Gets information about a specific custom domain association.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_custom_domain_association/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_custom_domain_association/) for full documentation.
#'
#' @param customDomainName &#91;required&#93; The custom domain name associated with the workgroup.
#' @param workgroupName &#91;required&#93; The name of the workgroup associated with the database.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_custom_domain_association
redshiftserverless_get_custom_domain_association <- function(customDomainName, workgroupName) {
  op <- new_operation(
    name = "GetCustomDomainAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_custom_domain_association_input(customDomainName = customDomainName, workgroupName = workgroupName)
  output <- .redshiftserverless$get_custom_domain_association_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_custom_domain_association <- redshiftserverless_get_custom_domain_association

#' Returns information, such as the name, about a VPC endpoint
#'
#' @description
#' Returns information, such as the name, about a VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_endpoint_access/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_endpoint_access/) for full documentation.
#'
#' @param endpointName &#91;required&#93; The name of the VPC endpoint to return information for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_endpoint_access
redshiftserverless_get_endpoint_access <- function(endpointName) {
  op <- new_operation(
    name = "GetEndpointAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_endpoint_access_input(endpointName = endpointName)
  output <- .redshiftserverless$get_endpoint_access_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_endpoint_access <- redshiftserverless_get_endpoint_access

#' Returns information about a namespace in Amazon Redshift Serverless
#'
#' @description
#' Returns information about a namespace in Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_namespace/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_namespace/) for full documentation.
#'
#' @param namespaceName &#91;required&#93; The name of the namespace to retrieve information for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_namespace
redshiftserverless_get_namespace <- function(namespaceName) {
  op <- new_operation(
    name = "GetNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_namespace_input(namespaceName = namespaceName)
  output <- .redshiftserverless$get_namespace_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_namespace <- redshiftserverless_get_namespace

#' Returns information about a recovery point
#'
#' @description
#' Returns information about a recovery point.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_recovery_point/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_recovery_point/) for full documentation.
#'
#' @param recoveryPointId &#91;required&#93; The unique identifier of the recovery point to return information for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_recovery_point
redshiftserverless_get_recovery_point <- function(recoveryPointId) {
  op <- new_operation(
    name = "GetRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_recovery_point_input(recoveryPointId = recoveryPointId)
  output <- .redshiftserverless$get_recovery_point_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_recovery_point <- redshiftserverless_get_recovery_point

#' Returns a resource policy
#'
#' @description
#' Returns a resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_resource_policy/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to return.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_resource_policy
redshiftserverless_get_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_resource_policy_input(resourceArn = resourceArn)
  output <- .redshiftserverless$get_resource_policy_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_resource_policy <- redshiftserverless_get_resource_policy

#' Returns information about a scheduled action
#'
#' @description
#' Returns information about a scheduled action.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_scheduled_action/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_scheduled_action/) for full documentation.
#'
#' @param scheduledActionName &#91;required&#93; The name of the scheduled action.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_scheduled_action
redshiftserverless_get_scheduled_action <- function(scheduledActionName) {
  op <- new_operation(
    name = "GetScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_scheduled_action_input(scheduledActionName = scheduledActionName)
  output <- .redshiftserverless$get_scheduled_action_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_scheduled_action <- redshiftserverless_get_scheduled_action

#' Returns information about a specific snapshot
#'
#' @description
#' Returns information about a specific snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_snapshot/) for full documentation.
#'
#' @param ownerAccount The owner Amazon Web Services account of a snapshot shared with another
#' user.
#' @param snapshotArn The Amazon Resource Name (ARN) of the snapshot to return.
#' @param snapshotName The name of the snapshot to return.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_snapshot
redshiftserverless_get_snapshot <- function(ownerAccount = NULL, snapshotArn = NULL, snapshotName = NULL) {
  op <- new_operation(
    name = "GetSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_snapshot_input(ownerAccount = ownerAccount, snapshotArn = snapshotArn, snapshotName = snapshotName)
  output <- .redshiftserverless$get_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_snapshot <- redshiftserverless_get_snapshot

#' Returns information about a TableRestoreStatus object
#'
#' @description
#' Returns information about a `TableRestoreStatus` object.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_table_restore_status/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_table_restore_status/) for full documentation.
#'
#' @param tableRestoreRequestId &#91;required&#93; The ID of the
#' [`restore_table_from_snapshot`][redshiftserverless_restore_table_from_snapshot]
#' request to return status for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_table_restore_status
redshiftserverless_get_table_restore_status <- function(tableRestoreRequestId) {
  op <- new_operation(
    name = "GetTableRestoreStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_table_restore_status_input(tableRestoreRequestId = tableRestoreRequestId)
  output <- .redshiftserverless$get_table_restore_status_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_table_restore_status <- redshiftserverless_get_table_restore_status

#' Returns information about a usage limit
#'
#' @description
#' Returns information about a usage limit.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_usage_limit/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_usage_limit/) for full documentation.
#'
#' @param usageLimitId &#91;required&#93; The unique identifier of the usage limit to return information for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_usage_limit
redshiftserverless_get_usage_limit <- function(usageLimitId) {
  op <- new_operation(
    name = "GetUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_usage_limit_input(usageLimitId = usageLimitId)
  output <- .redshiftserverless$get_usage_limit_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_usage_limit <- redshiftserverless_get_usage_limit

#' Returns information about a specific workgroup
#'
#' @description
#' Returns information about a specific workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_get_workgroup/](https://www.paws-r-sdk.com/docs/redshiftserverless_get_workgroup/) for full documentation.
#'
#' @param workgroupName &#91;required&#93; The name of the workgroup to return information for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_get_workgroup
redshiftserverless_get_workgroup <- function(workgroupName) {
  op <- new_operation(
    name = "GetWorkgroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$get_workgroup_input(workgroupName = workgroupName)
  output <- .redshiftserverless$get_workgroup_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$get_workgroup <- redshiftserverless_get_workgroup

#' Lists custom domain associations for Amazon Redshift Serverless
#'
#' @description
#' Lists custom domain associations for Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_custom_domain_associations/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_custom_domain_associations/) for full documentation.
#'
#' @param customDomainCertificateArn The custom domain name’s certificate Amazon resource name (ARN).
#' @param customDomainName The custom domain name associated with the workgroup.
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param nextToken When `nextToken` is returned, there are more results available. The
#' value of `nextToken` is a unique pagination token for each page. Make
#' the call again using the returned token to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_custom_domain_associations
redshiftserverless_list_custom_domain_associations <- function(customDomainCertificateArn = NULL, customDomainName = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCustomDomainAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "associations")
  )
  input <- .redshiftserverless$list_custom_domain_associations_input(customDomainCertificateArn = customDomainCertificateArn, customDomainName = customDomainName, maxResults = maxResults, nextToken = nextToken)
  output <- .redshiftserverless$list_custom_domain_associations_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_custom_domain_associations <- redshiftserverless_list_custom_domain_associations

#' Returns an array of EndpointAccess objects and relevant information
#'
#' @description
#' Returns an array of `EndpointAccess` objects and relevant information.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_endpoint_access/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_endpoint_access/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param nextToken If your initial
#' [`list_endpoint_access`][redshiftserverless_list_endpoint_access]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in following
#' [`list_endpoint_access`][redshiftserverless_list_endpoint_access]
#' operations, which returns results in the next page.
#' @param ownerAccount The owner Amazon Web Services account for the Amazon Redshift Serverless
#' workgroup.
#' @param vpcId The unique identifier of the virtual private cloud with access to Amazon
#' Redshift Serverless.
#' @param workgroupName The name of the workgroup associated with the VPC endpoint to return.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_endpoint_access
redshiftserverless_list_endpoint_access <- function(maxResults = NULL, nextToken = NULL, ownerAccount = NULL, vpcId = NULL, workgroupName = NULL) {
  op <- new_operation(
    name = "ListEndpointAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "endpoints")
  )
  input <- .redshiftserverless$list_endpoint_access_input(maxResults = maxResults, nextToken = nextToken, ownerAccount = ownerAccount, vpcId = vpcId, workgroupName = workgroupName)
  output <- .redshiftserverless$list_endpoint_access_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_endpoint_access <- redshiftserverless_list_endpoint_access

#' Returns information about a list of specified namespaces
#'
#' @description
#' Returns information about a list of specified namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_namespaces/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_namespaces/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param nextToken If your initial [`list_namespaces`][redshiftserverless_list_namespaces]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in following
#' [`list_namespaces`][redshiftserverless_list_namespaces] operations,
#' which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_namespaces
redshiftserverless_list_namespaces <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListNamespaces",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "namespaces")
  )
  input <- .redshiftserverless$list_namespaces_input(maxResults = maxResults, nextToken = nextToken)
  output <- .redshiftserverless$list_namespaces_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_namespaces <- redshiftserverless_list_namespaces

#' Returns an array of recovery points
#'
#' @description
#' Returns an array of recovery points.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_recovery_points/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_recovery_points/) for full documentation.
#'
#' @param endTime The time when creation of the recovery point finished.
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param namespaceArn The Amazon Resource Name (ARN) of the namespace from which to list
#' recovery points.
#' @param namespaceName The name of the namespace to list recovery points for.
#' @param nextToken If your initial
#' [`list_recovery_points`][redshiftserverless_list_recovery_points]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in following
#' [`list_recovery_points`][redshiftserverless_list_recovery_points]
#' operations, which returns results in the next page.
#' @param startTime The time when the recovery point's creation was initiated.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_recovery_points
redshiftserverless_list_recovery_points <- function(endTime = NULL, maxResults = NULL, namespaceArn = NULL, namespaceName = NULL, nextToken = NULL, startTime = NULL) {
  op <- new_operation(
    name = "ListRecoveryPoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "recoveryPoints")
  )
  input <- .redshiftserverless$list_recovery_points_input(endTime = endTime, maxResults = maxResults, namespaceArn = namespaceArn, namespaceName = namespaceName, nextToken = nextToken, startTime = startTime)
  output <- .redshiftserverless$list_recovery_points_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_recovery_points <- redshiftserverless_list_recovery_points

#' Returns a list of scheduled actions
#'
#' @description
#' Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_scheduled_actions/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_scheduled_actions/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. Use `nextToken` to display the next page of results.
#' @param namespaceName The name of namespace associated with the scheduled action to retrieve.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_scheduled_actions
redshiftserverless_list_scheduled_actions <- function(maxResults = NULL, namespaceName = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListScheduledActions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "scheduledActions")
  )
  input <- .redshiftserverless$list_scheduled_actions_input(maxResults = maxResults, namespaceName = namespaceName, nextToken = nextToken)
  output <- .redshiftserverless$list_scheduled_actions_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_scheduled_actions <- redshiftserverless_list_scheduled_actions

#' Returns a list of snapshot copy configurations
#'
#' @description
#' Returns a list of snapshot copy configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_snapshot_copy_configurations/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_snapshot_copy_configurations/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param namespaceName The namespace from which to list all snapshot copy configurations.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_snapshot_copy_configurations
redshiftserverless_list_snapshot_copy_configurations <- function(maxResults = NULL, namespaceName = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSnapshotCopyConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "snapshotCopyConfigurations")
  )
  input <- .redshiftserverless$list_snapshot_copy_configurations_input(maxResults = maxResults, namespaceName = namespaceName, nextToken = nextToken)
  output <- .redshiftserverless$list_snapshot_copy_configurations_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_snapshot_copy_configurations <- redshiftserverless_list_snapshot_copy_configurations

#' Returns a list of snapshots
#'
#' @description
#' Returns a list of snapshots.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_snapshots/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_snapshots/) for full documentation.
#'
#' @param endTime The timestamp showing when the snapshot creation finished.
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param namespaceArn The Amazon Resource Name (ARN) of the namespace from which to list all
#' snapshots.
#' @param namespaceName The namespace from which to list all snapshots.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page.
#' @param ownerAccount The owner Amazon Web Services account of the snapshot.
#' @param startTime The time when the creation of the snapshot was initiated.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_snapshots
redshiftserverless_list_snapshots <- function(endTime = NULL, maxResults = NULL, namespaceArn = NULL, namespaceName = NULL, nextToken = NULL, ownerAccount = NULL, startTime = NULL) {
  op <- new_operation(
    name = "ListSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "snapshots")
  )
  input <- .redshiftserverless$list_snapshots_input(endTime = endTime, maxResults = maxResults, namespaceArn = namespaceArn, namespaceName = namespaceName, nextToken = nextToken, ownerAccount = ownerAccount, startTime = startTime)
  output <- .redshiftserverless$list_snapshots_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_snapshots <- redshiftserverless_list_snapshots

#' Returns information about an array of TableRestoreStatus objects
#'
#' @description
#' Returns information about an array of `TableRestoreStatus` objects.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_table_restore_status/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_table_restore_status/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use nextToken to display the next page of results.
#' @param namespaceName The namespace from which to list all of the statuses of
#' [`restore_table_from_snapshot`][redshiftserverless_restore_table_from_snapshot]
#' operations .
#' @param nextToken If your initial
#' [`list_table_restore_status`][redshiftserverless_list_table_restore_status]
#' operation returns a nextToken, you can include the returned `nextToken`
#' in following
#' [`list_table_restore_status`][redshiftserverless_list_table_restore_status]
#' operations. This will return results on the next page.
#' @param workgroupName The workgroup from which to list all of the statuses of
#' [`restore_table_from_snapshot`][redshiftserverless_restore_table_from_snapshot]
#' operations.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_table_restore_status
redshiftserverless_list_table_restore_status <- function(maxResults = NULL, namespaceName = NULL, nextToken = NULL, workgroupName = NULL) {
  op <- new_operation(
    name = "ListTableRestoreStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "tableRestoreStatuses")
  )
  input <- .redshiftserverless$list_table_restore_status_input(maxResults = maxResults, namespaceName = namespaceName, nextToken = nextToken, workgroupName = workgroupName)
  output <- .redshiftserverless$list_table_restore_status_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_table_restore_status <- redshiftserverless_list_table_restore_status

#' Lists the tags assigned to a resource
#'
#' @description
#' Lists the tags assigned to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to list tags for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_tags_for_resource
redshiftserverless_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .redshiftserverless$list_tags_for_resource_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_tags_for_resource <- redshiftserverless_list_tags_for_resource

#' Lists all usage limits within Amazon Redshift Serverless
#'
#' @description
#' Lists all usage limits within Amazon Redshift Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_usage_limits/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_usage_limits/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results. The
#' default is 100.
#' @param nextToken If your initial
#' [`list_usage_limits`][redshiftserverless_list_usage_limits] operation
#' returns a `nextToken`, you can include the returned `nextToken` in
#' following [`list_usage_limits`][redshiftserverless_list_usage_limits]
#' operations, which returns results in the next page.
#' @param resourceArn The Amazon Resource Name (ARN) associated with the resource whose usage
#' limits you want to list.
#' @param usageType The Amazon Redshift Serverless feature whose limits you want to see.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_usage_limits
redshiftserverless_list_usage_limits <- function(maxResults = NULL, nextToken = NULL, resourceArn = NULL, usageType = NULL) {
  op <- new_operation(
    name = "ListUsageLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "usageLimits")
  )
  input <- .redshiftserverless$list_usage_limits_input(maxResults = maxResults, nextToken = nextToken, resourceArn = resourceArn, usageType = usageType)
  output <- .redshiftserverless$list_usage_limits_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_usage_limits <- redshiftserverless_list_usage_limits

#' Returns information about a list of specified workgroups
#'
#' @description
#' Returns information about a list of specified workgroups.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_list_workgroups/](https://www.paws-r-sdk.com/docs/redshiftserverless_list_workgroups/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to display the next page of results.
#' @param nextToken If your initial ListWorkgroups operation returns a `nextToken`, you can
#' include the returned `nextToken` in following ListNamespaces operations,
#' which returns results in the next page.
#' @param ownerAccount The owner Amazon Web Services account for the Amazon Redshift Serverless
#' workgroup.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_list_workgroups
redshiftserverless_list_workgroups <- function(maxResults = NULL, nextToken = NULL, ownerAccount = NULL) {
  op <- new_operation(
    name = "ListWorkgroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "workgroups")
  )
  input <- .redshiftserverless$list_workgroups_input(maxResults = maxResults, nextToken = nextToken, ownerAccount = ownerAccount)
  output <- .redshiftserverless$list_workgroups_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$list_workgroups <- redshiftserverless_list_workgroups

#' Creates or updates a resource policy
#'
#' @description
#' Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_put_resource_policy/](https://www.paws-r-sdk.com/docs/redshiftserverless_put_resource_policy/) for full documentation.
#'
#' @param policy &#91;required&#93; The policy to create or update. For example, the following policy grants
#' a user authorization to restore a snapshot.
#' 
#' `"{\"Version\": \"2012-10-17\", \"Statement\" : [{ \"Sid\": \"AllowUserRestoreFromSnapshot\", \"Principal\":{\"AWS\": [\"739247239426\"]}, \"Action\": [\"redshift-serverless:RestoreFromSnapshot\"] , \"Effect\": \"Allow\" }]}"`
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the account to create or update a
#' resource policy for.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_put_resource_policy
redshiftserverless_put_resource_policy <- function(policy, resourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$put_resource_policy_input(policy = policy, resourceArn = resourceArn)
  output <- .redshiftserverless$put_resource_policy_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$put_resource_policy <- redshiftserverless_put_resource_policy

#' Restore the data from a recovery point
#'
#' @description
#' Restore the data from a recovery point.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_restore_from_recovery_point/](https://www.paws-r-sdk.com/docs/redshiftserverless_restore_from_recovery_point/) for full documentation.
#'
#' @param namespaceName &#91;required&#93; The name of the namespace to restore data into.
#' @param recoveryPointId &#91;required&#93; The unique identifier of the recovery point to restore from.
#' @param workgroupName &#91;required&#93; The name of the workgroup used to restore data.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_restore_from_recovery_point
redshiftserverless_restore_from_recovery_point <- function(namespaceName, recoveryPointId, workgroupName) {
  op <- new_operation(
    name = "RestoreFromRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$restore_from_recovery_point_input(namespaceName = namespaceName, recoveryPointId = recoveryPointId, workgroupName = workgroupName)
  output <- .redshiftserverless$restore_from_recovery_point_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$restore_from_recovery_point <- redshiftserverless_restore_from_recovery_point

#' Restores a namespace from a snapshot
#'
#' @description
#' Restores a namespace from a snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_restore_from_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_restore_from_snapshot/) for full documentation.
#'
#' @param adminPasswordSecretKmsKeyId The ID of the Key Management Service (KMS) key used to encrypt and store
#' the namespace's admin credentials secret.
#' @param manageAdminPassword If `true`, Amazon Redshift uses Secrets Manager to manage the restored
#' snapshot's admin credentials. If `MmanageAdminPassword` is false or not
#' set, Amazon Redshift uses the admin credentials that the namespace or
#' cluster had at the time the snapshot was taken.
#' @param namespaceName &#91;required&#93; The name of the namespace to restore the snapshot to.
#' @param ownerAccount The Amazon Web Services account that owns the snapshot.
#' @param snapshotArn The Amazon Resource Name (ARN) of the snapshot to restore from. Required
#' if restoring from Amazon Redshift Serverless to a provisioned cluster.
#' Must not be specified at the same time as `snapshotName`.
#' 
#' The format of the ARN is
#' arn:aws:redshift:\<region\>:\<account_id\>:snapshot:\<cluster_identifier\>/\<snapshot_identifier\>.
#' @param snapshotName The name of the snapshot to restore from. Must not be specified at the
#' same time as `snapshotArn`.
#' @param workgroupName &#91;required&#93; The name of the workgroup used to restore the snapshot.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_restore_from_snapshot
redshiftserverless_restore_from_snapshot <- function(adminPasswordSecretKmsKeyId = NULL, manageAdminPassword = NULL, namespaceName, ownerAccount = NULL, snapshotArn = NULL, snapshotName = NULL, workgroupName) {
  op <- new_operation(
    name = "RestoreFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$restore_from_snapshot_input(adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId, manageAdminPassword = manageAdminPassword, namespaceName = namespaceName, ownerAccount = ownerAccount, snapshotArn = snapshotArn, snapshotName = snapshotName, workgroupName = workgroupName)
  output <- .redshiftserverless$restore_from_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$restore_from_snapshot <- redshiftserverless_restore_from_snapshot

#' Restores a table from a recovery point to your Amazon Redshift
#' Serverless instance
#'
#' @description
#' Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with interleaved sort keys.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_recovery_point/](https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_recovery_point/) for full documentation.
#'
#' @param activateCaseSensitiveIdentifier Indicates whether name identifiers for database, schema, and table are
#' case sensitive. If true, the names are case sensitive. If false, the
#' names are not case sensitive. The default is false.
#' @param namespaceName &#91;required&#93; Namespace of the recovery point to restore from.
#' @param newTableName &#91;required&#93; The name of the table to create from the restore operation.
#' @param recoveryPointId &#91;required&#93; The ID of the recovery point to restore the table from.
#' @param sourceDatabaseName &#91;required&#93; The name of the source database that contains the table being restored.
#' @param sourceSchemaName The name of the source schema that contains the table being restored.
#' @param sourceTableName &#91;required&#93; The name of the source table being restored.
#' @param targetDatabaseName The name of the database to restore the table to.
#' @param targetSchemaName The name of the schema to restore the table to.
#' @param workgroupName &#91;required&#93; The workgroup to restore the table to.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_restore_table_from_recovery_point
redshiftserverless_restore_table_from_recovery_point <- function(activateCaseSensitiveIdentifier = NULL, namespaceName, newTableName, recoveryPointId, sourceDatabaseName, sourceSchemaName = NULL, sourceTableName, targetDatabaseName = NULL, targetSchemaName = NULL, workgroupName) {
  op <- new_operation(
    name = "RestoreTableFromRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$restore_table_from_recovery_point_input(activateCaseSensitiveIdentifier = activateCaseSensitiveIdentifier, namespaceName = namespaceName, newTableName = newTableName, recoveryPointId = recoveryPointId, sourceDatabaseName = sourceDatabaseName, sourceSchemaName = sourceSchemaName, sourceTableName = sourceTableName, targetDatabaseName = targetDatabaseName, targetSchemaName = targetSchemaName, workgroupName = workgroupName)
  output <- .redshiftserverless$restore_table_from_recovery_point_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$restore_table_from_recovery_point <- redshiftserverless_restore_table_from_recovery_point

#' Restores a table from a snapshot to your Amazon Redshift Serverless
#' instance
#'
#' @description
#' Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with [interleaved sort keys](https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_snapshot/) for full documentation.
#'
#' @param activateCaseSensitiveIdentifier Indicates whether name identifiers for database, schema, and table are
#' case sensitive. If true, the names are case sensitive. If false, the
#' names are not case sensitive. The default is false.
#' @param namespaceName &#91;required&#93; The namespace of the snapshot to restore from.
#' @param newTableName &#91;required&#93; The name of the table to create from the restore operation.
#' @param snapshotName &#91;required&#93; The name of the snapshot to restore the table from.
#' @param sourceDatabaseName &#91;required&#93; The name of the source database that contains the table being restored.
#' @param sourceSchemaName The name of the source schema that contains the table being restored.
#' @param sourceTableName &#91;required&#93; The name of the source table being restored.
#' @param targetDatabaseName The name of the database to restore the table to.
#' @param targetSchemaName The name of the schema to restore the table to.
#' @param workgroupName &#91;required&#93; The workgroup to restore the table to.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_restore_table_from_snapshot
redshiftserverless_restore_table_from_snapshot <- function(activateCaseSensitiveIdentifier = NULL, namespaceName, newTableName, snapshotName, sourceDatabaseName, sourceSchemaName = NULL, sourceTableName, targetDatabaseName = NULL, targetSchemaName = NULL, workgroupName) {
  op <- new_operation(
    name = "RestoreTableFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$restore_table_from_snapshot_input(activateCaseSensitiveIdentifier = activateCaseSensitiveIdentifier, namespaceName = namespaceName, newTableName = newTableName, snapshotName = snapshotName, sourceDatabaseName = sourceDatabaseName, sourceSchemaName = sourceSchemaName, sourceTableName = sourceTableName, targetDatabaseName = targetDatabaseName, targetSchemaName = targetSchemaName, workgroupName = workgroupName)
  output <- .redshiftserverless$restore_table_from_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$restore_table_from_snapshot <- redshiftserverless_restore_table_from_snapshot

#' Assigns one or more tags to a resource
#'
#' @description
#' Assigns one or more tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_tag_resource/](https://www.paws-r-sdk.com/docs/redshiftserverless_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to tag.
#' @param tags &#91;required&#93; The map of the key-value pairs used to tag the resource.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_tag_resource
redshiftserverless_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .redshiftserverless$tag_resource_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$tag_resource <- redshiftserverless_tag_resource

#' Removes a tag or set of tags from a resource
#'
#' @description
#' Removes a tag or set of tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_untag_resource/](https://www.paws-r-sdk.com/docs/redshiftserverless_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from.
#' @param tagKeys &#91;required&#93; The tag or set of tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_untag_resource
redshiftserverless_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .redshiftserverless$untag_resource_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$untag_resource <- redshiftserverless_untag_resource

#' Updates an Amazon Redshift Serverless certificate associated with a
#' custom domain
#'
#' @description
#' Updates an Amazon Redshift Serverless certificate associated with a custom domain.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_custom_domain_association/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_custom_domain_association/) for full documentation.
#'
#' @param customDomainCertificateArn &#91;required&#93; The custom domain name’s certificate Amazon resource name (ARN). This is
#' optional.
#' @param customDomainName &#91;required&#93; The custom domain name associated with the workgroup.
#' @param workgroupName &#91;required&#93; The name of the workgroup associated with the database.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_custom_domain_association
redshiftserverless_update_custom_domain_association <- function(customDomainCertificateArn, customDomainName, workgroupName) {
  op <- new_operation(
    name = "UpdateCustomDomainAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_custom_domain_association_input(customDomainCertificateArn = customDomainCertificateArn, customDomainName = customDomainName, workgroupName = workgroupName)
  output <- .redshiftserverless$update_custom_domain_association_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_custom_domain_association <- redshiftserverless_update_custom_domain_association

#' Updates an Amazon Redshift Serverless managed endpoint
#'
#' @description
#' Updates an Amazon Redshift Serverless managed endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_endpoint_access/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_endpoint_access/) for full documentation.
#'
#' @param endpointName &#91;required&#93; The name of the VPC endpoint to update.
#' @param vpcSecurityGroupIds The list of VPC security groups associated with the endpoint after the
#' endpoint is modified.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_endpoint_access
redshiftserverless_update_endpoint_access <- function(endpointName, vpcSecurityGroupIds = NULL) {
  op <- new_operation(
    name = "UpdateEndpointAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_endpoint_access_input(endpointName = endpointName, vpcSecurityGroupIds = vpcSecurityGroupIds)
  output <- .redshiftserverless$update_endpoint_access_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_endpoint_access <- redshiftserverless_update_endpoint_access

#' Updates a namespace with the specified settings
#'
#' @description
#' Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one request. For example, you must specify both `adminUsername` and `adminUserPassword` to update either field, but you can't update both `kmsKeyId` and `logExports` in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_namespace/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_namespace/) for full documentation.
#'
#' @param adminPasswordSecretKmsKeyId The ID of the Key Management Service (KMS) key used to encrypt and store
#' the namespace's admin credentials secret. You can only use this
#' parameter if `manageAdminPassword` is true.
#' @param adminUserPassword The password of the administrator for the first database created in the
#' namespace. This parameter must be updated together with `adminUsername`.
#' 
#' You can't use `adminUserPassword` if `manageAdminPassword` is true.
#' @param adminUsername The username of the administrator for the first database created in the
#' namespace. This parameter must be updated together with
#' `adminUserPassword`.
#' @param defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in
#' the namespace. This parameter must be updated together with `iamRoles`.
#' @param iamRoles A list of IAM roles to associate with the namespace. This parameter must
#' be updated together with `defaultIamRoleArn`.
#' @param kmsKeyId The ID of the Amazon Web Services Key Management Service key used to
#' encrypt your data.
#' @param logExports The types of logs the namespace can export. The export types are
#' `userlog`, `connectionlog`, and `useractivitylog`.
#' @param manageAdminPassword If `true`, Amazon Redshift uses Secrets Manager to manage the
#' namespace's admin credentials. You can't use `adminUserPassword` if
#' `manageAdminPassword` is true. If `manageAdminPassword` is false or not
#' set, Amazon Redshift uses `adminUserPassword` for the admin user
#' account's password.
#' @param namespaceName &#91;required&#93; The name of the namespace to update. You can't update the name of a
#' namespace once it is created.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_namespace
redshiftserverless_update_namespace <- function(adminPasswordSecretKmsKeyId = NULL, adminUserPassword = NULL, adminUsername = NULL, defaultIamRoleArn = NULL, iamRoles = NULL, kmsKeyId = NULL, logExports = NULL, manageAdminPassword = NULL, namespaceName) {
  op <- new_operation(
    name = "UpdateNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_namespace_input(adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId, adminUserPassword = adminUserPassword, adminUsername = adminUsername, defaultIamRoleArn = defaultIamRoleArn, iamRoles = iamRoles, kmsKeyId = kmsKeyId, logExports = logExports, manageAdminPassword = manageAdminPassword, namespaceName = namespaceName)
  output <- .redshiftserverless$update_namespace_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_namespace <- redshiftserverless_update_namespace

#' Updates a scheduled action
#'
#' @description
#' Updates a scheduled action.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_scheduled_action/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_scheduled_action/) for full documentation.
#'
#' @param enabled Specifies whether to enable the scheduled action.
#' @param endTime The end time in UTC of the scheduled action to update.
#' @param roleArn The ARN of the IAM role to assume to run the scheduled action. This IAM
#' role must have permission to run the Amazon Redshift Serverless API
#' operation in the scheduled action. This IAM role must allow the Amazon
#' Redshift scheduler to schedule creating snapshots (Principal
#' scheduler.redshift.amazonaws.com) to assume permissions on your behalf.
#' For more information about the IAM role to use with the Amazon Redshift
#' scheduler, see [Using Identity-Based Policies for Amazon
#' Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
#' in the Amazon Redshift Cluster Management Guide
#' @param schedule The schedule for a one-time (at format) or recurring (cron format)
#' scheduled action. Schedule invocations must be separated by at least one
#' hour.
#' 
#' Format of at expressions is "`at(yyyy-mm-ddThh:mm:ss)`". For example,
#' "`at(2016-03-04T17:27:00)`".
#' 
#' Format of cron expressions is
#' "`cron(Minutes Hours Day-of-month Month Day-of-week Year)`". For
#' example, "`cron(0 10 ? * MON *)`". For more information, see [Cron
#' Expressions](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html#CronExpressions)
#' in the *Amazon CloudWatch Events User Guide*.
#' @param scheduledActionDescription The descripion of the scheduled action to update to.
#' @param scheduledActionName &#91;required&#93; The name of the scheduled action to update to.
#' @param startTime The start time in UTC of the scheduled action to update to.
#' @param targetAction 
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_scheduled_action
redshiftserverless_update_scheduled_action <- function(enabled = NULL, endTime = NULL, roleArn = NULL, schedule = NULL, scheduledActionDescription = NULL, scheduledActionName, startTime = NULL, targetAction = NULL) {
  op <- new_operation(
    name = "UpdateScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_scheduled_action_input(enabled = enabled, endTime = endTime, roleArn = roleArn, schedule = schedule, scheduledActionDescription = scheduledActionDescription, scheduledActionName = scheduledActionName, startTime = startTime, targetAction = targetAction)
  output <- .redshiftserverless$update_scheduled_action_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_scheduled_action <- redshiftserverless_update_scheduled_action

#' Updates a snapshot
#'
#' @description
#' Updates a snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_snapshot/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_snapshot/) for full documentation.
#'
#' @param retentionPeriod The new retention period of the snapshot.
#' @param snapshotName &#91;required&#93; The name of the snapshot.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_snapshot
redshiftserverless_update_snapshot <- function(retentionPeriod = NULL, snapshotName) {
  op <- new_operation(
    name = "UpdateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_snapshot_input(retentionPeriod = retentionPeriod, snapshotName = snapshotName)
  output <- .redshiftserverless$update_snapshot_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_snapshot <- redshiftserverless_update_snapshot

#' Updates a snapshot copy configuration
#'
#' @description
#' Updates a snapshot copy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_snapshot_copy_configuration/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_snapshot_copy_configuration/) for full documentation.
#'
#' @param snapshotCopyConfigurationId &#91;required&#93; The ID of the snapshot copy configuration to update.
#' @param snapshotRetentionPeriod The new retention period of how long to keep a snapshot in the
#' destination Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_snapshot_copy_configuration
redshiftserverless_update_snapshot_copy_configuration <- function(snapshotCopyConfigurationId, snapshotRetentionPeriod = NULL) {
  op <- new_operation(
    name = "UpdateSnapshotCopyConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_snapshot_copy_configuration_input(snapshotCopyConfigurationId = snapshotCopyConfigurationId, snapshotRetentionPeriod = snapshotRetentionPeriod)
  output <- .redshiftserverless$update_snapshot_copy_configuration_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_snapshot_copy_configuration <- redshiftserverless_update_snapshot_copy_configuration

#' Update a usage limit in Amazon Redshift Serverless
#'
#' @description
#' Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_usage_limit/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_usage_limit/) for full documentation.
#'
#' @param amount The new limit amount. If time-based, this amount is in Redshift
#' Processing Units (RPU) consumed per hour. If data-based, this amount is
#' in terabytes (TB) of data transferred between Regions in cross-account
#' sharing. The value must be a positive number.
#' @param breachAction The new action that Amazon Redshift Serverless takes when the limit is
#' reached.
#' @param usageLimitId &#91;required&#93; The identifier of the usage limit to update.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_usage_limit
redshiftserverless_update_usage_limit <- function(amount = NULL, breachAction = NULL, usageLimitId) {
  op <- new_operation(
    name = "UpdateUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_usage_limit_input(amount = amount, breachAction = breachAction, usageLimitId = usageLimitId)
  output <- .redshiftserverless$update_usage_limit_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_usage_limit <- redshiftserverless_update_usage_limit

#' Updates a workgroup with the specified configuration settings
#'
#' @description
#' Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one request. For example, you can update `baseCapacity` or `port` in a single request, but you can't update both in the same request.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftserverless_update_workgroup/](https://www.paws-r-sdk.com/docs/redshiftserverless_update_workgroup/) for full documentation.
#'
#' @param baseCapacity The new base data warehouse capacity in Redshift Processing Units
#' (RPUs).
#' @param configParameters An array of parameters to set for advanced control over a database. The
#' options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`,
#' `enable_user_activity_logging`, `query_group`, `search_path`, and query
#' monitoring metrics that let you define performance boundaries. For more
#' information about query monitoring rules and available metrics, see
#' [Query monitoring metrics for Amazon Redshift
#' Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
#' @param enhancedVpcRouting The value that specifies whether to turn on enhanced virtual private
#' cloud (VPC) routing, which forces Amazon Redshift Serverless to route
#' traffic through your VPC.
#' @param maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to
#' serve queries. The max capacity is specified in RPUs.
#' @param port The custom port to use when connecting to a workgroup. Valid port ranges
#' are 5431-5455 and 8191-8215. The default is 5439.
#' @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a
#' public network.
#' @param securityGroupIds An array of security group IDs to associate with the workgroup.
#' @param subnetIds An array of VPC subnet IDs to associate with the workgroup.
#' @param workgroupName &#91;required&#93; The name of the workgroup to update. You can't update the name of a
#' workgroup once it is created.
#'
#' @keywords internal
#'
#' @rdname redshiftserverless_update_workgroup
redshiftserverless_update_workgroup <- function(baseCapacity = NULL, configParameters = NULL, enhancedVpcRouting = NULL, maxCapacity = NULL, port = NULL, publiclyAccessible = NULL, securityGroupIds = NULL, subnetIds = NULL, workgroupName) {
  op <- new_operation(
    name = "UpdateWorkgroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshiftserverless$update_workgroup_input(baseCapacity = baseCapacity, configParameters = configParameters, enhancedVpcRouting = enhancedVpcRouting, maxCapacity = maxCapacity, port = port, publiclyAccessible = publiclyAccessible, securityGroupIds = securityGroupIds, subnetIds = subnetIds, workgroupName = workgroupName)
  output <- .redshiftserverless$update_workgroup_output()
  config <- get_config()
  svc <- .redshiftserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftserverless$operations$update_workgroup <- redshiftserverless_update_workgroup
