# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon SimpleDB
#'
#' @description
#' Amazon SimpleDB is a web service providing the core database functions
#' of data indexing and querying in the cloud. By offloading the time and
#' effort associated with building and operating a web-scale database,
#' SimpleDB provides developers the freedom to focus on application
#' development.
#' 
#' A traditional, clustered relational database requires a sizable upfront
#' capital outlay, is complex to design, and often requires extensive and
#' repetitive database administration. Amazon SimpleDB is dramatically
#' simpler, requiring no schema, automatically indexing your data and
#' providing a simple API for storage and access. This approach eliminates
#' the administrative burden of data modeling, index maintenance, and
#' performance tuning. Developers gain access to this functionality within
#' Amazon's proven computing environment, are able to scale instantly, and
#' pay only for what they use.
#' 
#' Visit
#' [http://aws.amazon.com/simpledb/](https://aws.amazon.com/simpledb/) for
#' more information.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- simpledb(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- simpledb()
#' svc$batch_delete_attributes(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=simpledb_batch_delete_attributes]{batch_delete_attributes} \tab Performs multiple DeleteAttributes operations in a single call, which reduces round trips and latencies\cr
#'  \link[=simpledb_batch_put_attributes]{batch_put_attributes} \tab The BatchPutAttributes operation creates or replaces attributes within one or more items\cr
#'  \link[=simpledb_create_domain]{create_domain} \tab The CreateDomain operation creates a new domain\cr
#'  \link[=simpledb_delete_attributes]{delete_attributes} \tab Deletes one or more attributes associated with an item\cr
#'  \link[=simpledb_delete_domain]{delete_domain} \tab The DeleteDomain operation deletes a domain\cr
#'  \link[=simpledb_domain_metadata]{domain_metadata} \tab Returns information about the domain, including when the domain was created, the number of items and attributes in the domain, and the size of the attribute names and values\cr
#'  \link[=simpledb_get_attributes]{get_attributes} \tab Returns all of the attributes associated with the specified item\cr
#'  \link[=simpledb_list_domains]{list_domains} \tab The ListDomains operation lists all domains associated with the Access Key ID\cr
#'  \link[=simpledb_put_attributes]{put_attributes} \tab The PutAttributes operation creates or replaces attributes in an item\cr
#'  \link[=simpledb_select]{select} \tab The Select operation returns a set of attributes for ItemNames that match the select expression
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname simpledb
#' @export
simpledb <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .simpledb$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.simpledb <- list()

.simpledb$operations <- list()

.simpledb$metadata <- list(
  service_name = "sdb",
  endpoints = list("us-east-1" = list(endpoint = "sdb.amazonaws.com", global = FALSE), "*" = list(endpoint = "sdb.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sdb.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "sdb.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "sdb.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "SimpleDB",
  api_version = "2009-04-15",
  signing_name = "sdb",
  json_version = "",
  target_prefix = ""
)

.simpledb$service <- function(config = list()) {
  handlers <- new_handlers("query", "v2")
  new_service(.simpledb$metadata, handlers, config)
}
