% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_cluster_security_groups}
\alias{redshift_describe_cluster_security_groups}
\title{Returns information about Amazon Redshift security groups}
\usage{
redshift_describe_cluster_security_groups(ClusterSecurityGroupName,
  MaxRecords, Marker, TagKeys, TagValues)
}
\arguments{
\item{ClusterSecurityGroupName}{The name of a cluster security group for which you are requesting
details. You can specify either the \strong{Marker} parameter or a
\strong{ClusterSecurityGroupName} parameter, but not both.

Example: \code{securitygroup1}}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeClusterSecurityGroups
request exceed the value specified in \code{MaxRecords}, AWS returns a value
in the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.

Constraints: You can specify either the \strong{ClusterSecurityGroupName}
parameter or the \strong{Marker} parameter, but not both.}

\item{TagKeys}{A tag key or keys for which you want to return all matching cluster
security groups that are associated with the specified key or keys. For
example, suppose that you have security groups that are tagged with keys
called \code{owner} and \code{environment}. If you specify both of these tag keys
in the request, Amazon Redshift returns a response with the security
groups that have either or both of these tag keys associated with them.}

\item{TagValues}{A tag value or values for which you want to return all matching cluster
security groups that are associated with the specified tag value or
values. For example, suppose that you have security groups that are
tagged with values called \code{admin} and \code{test}. If you specify both of
these tag values in the request, Amazon Redshift returns a response with
the security groups that have either or both of these tag values
associated with them.}
}
\description{
Returns information about Amazon Redshift security groups. If the name
of a security group is specified, the response will contain only
information about only that security group.
}
\details{
For information about managing security groups, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html}{Amazon Redshift Cluster Security Groups}
in the \emph{Amazon Redshift Cluster Management Guide}.

If you specify both tag keys and tag values in the same request, Amazon
Redshift returns all security groups that match any combination of the
specified keys and values. For example, if you have \code{owner} and
\code{environment} for tag keys, and \code{admin} and \code{test} for tag values, all
security groups that have any combination of those values are returned.

If both tag keys and values are omitted from the request, security
groups are returned regardless of whether they have tag keys or values
associated with them.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster_security_groups(
  ClusterSecurityGroupName = "string",
  MaxRecords = 123,
  Marker = "string",
  TagKeys = list(
    "string"
  ),
  TagValues = list(
    "string"
  )
)
}
}

\keyword{internal}
