% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_untag_resource}
\alias{dynamodb_untag_resource}
\title{Removes the association of tags from an Amazon DynamoDB resource}
\usage{
dynamodb_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The DynamoDB resource that the tags will be removed from. This value is
an Amazon Resource Name (ARN).}

\item{TagKeys}{[required] A list of tag keys. Existing tags of the resource whose keys are members
of this list will be removed from the DynamoDB resource.}
}
\description{
Removes the association of tags from an Amazon DynamoDB resource. You
can call \code{UntagResource} up to five times per second, per account.
}
\details{
For an overview on tagging DynamoDB resources, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html}{Tagging for DynamoDB}
in the \emph{Amazon DynamoDB Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
