% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_parameter_groups}
\alias{rds_describe_db_parameter_groups}
\title{Returns a list of DBParameterGroup descriptions}
\usage{
rds_describe_db_parameter_groups(DBParameterGroupName, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{DBParameterGroupName}{The name of a specific DB parameter group to return details for.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBParameterGroups} request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns a list of \code{DBParameterGroup} descriptions. If a
\code{DBParameterGroupName} is specified, the list will contain only the
description of the specified DB parameter group.
}
\section{Request syntax}{
\preformatted{svc$describe_db_parameter_groups(
  DBParameterGroupName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
