% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_reboot_db_instance}
\alias{docdb_reboot_db_instance}
\title{You might need to reboot your instance, usually for maintenance reasons}
\usage{
docdb_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The instance identifier. This parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing \code{DBInstance}.
}}

\item{ForceFailover}{When \code{true}, the reboot is conducted through a Multi-AZ failover.

Constraint: You can't specify \code{true} if the instance is not configured
for Multi-AZ.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      )
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    EnabledCloudwatchLogsExports = list(
      "string"
    )
  )
)
}
}
\description{
You might need to reboot your instance, usually for maintenance reasons.
For example, if you make certain changes, or if you change the cluster
parameter group that is associated with the instance, you must reboot
the instance for the changes to take effect.

Rebooting an instance restarts the database engine service. Rebooting an
instance results in a momentary outage, during which the instance status
is set to \emph{rebooting}.
}
\section{Request syntax}{
\preformatted{svc$reboot_db_instance(
  DBInstanceIdentifier = "string",
  ForceFailover = TRUE|FALSE
)
}
}

\keyword{internal}
