% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_scheduled_action}
\alias{redshift_modify_scheduled_action}
\title{Modifies a scheduled action}
\usage{
redshift_modify_scheduled_action(ScheduledActionName, TargetAction,
  Schedule, IamRole, ScheduledActionDescription, StartTime, EndTime,
  Enable)
}
\arguments{
\item{ScheduledActionName}{[required] The name of the scheduled action to modify.}

\item{TargetAction}{A modified JSON format of the scheduled action. For more information
about this parameter, see ScheduledAction.}

\item{Schedule}{A modified schedule in either \code{at( )} or \code{cron( )} format. For more
information about this parameter, see ScheduledAction.}

\item{IamRole}{A different IAM role to assume to run the target action. For more
information about this parameter, see ScheduledAction.}

\item{ScheduledActionDescription}{A modified description of the scheduled action.}

\item{StartTime}{A modified start time of the scheduled action. For more information
about this parameter, see ScheduledAction.}

\item{EndTime}{A modified end time of the scheduled action. For more information about
this parameter, see ScheduledAction.}

\item{Enable}{A modified enable flag of the scheduled action. If true, the scheduled
action is active. If false, the scheduled action is disabled.}
}
\value{
A list with the following syntax:\preformatted{list(
  ScheduledActionName = "string",
  TargetAction = list(
    ResizeCluster = list(
      ClusterIdentifier = "string",
      ClusterType = "string",
      NodeType = "string",
      NumberOfNodes = 123,
      Classic = TRUE|FALSE
    ),
    PauseCluster = list(
      ClusterIdentifier = "string"
    ),
    ResumeCluster = list(
      ClusterIdentifier = "string"
    )
  ),
  Schedule = "string",
  IamRole = "string",
  ScheduledActionDescription = "string",
  State = "ACTIVE"|"DISABLED",
  NextInvocations = list(
    as.POSIXct(
      "2015-01-01"
    )
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Modifies a scheduled action.
}
\section{Request syntax}{
\preformatted{svc$modify_scheduled_action(
  ScheduledActionName = "string",
  TargetAction = list(
    ResizeCluster = list(
      ClusterIdentifier = "string",
      ClusterType = "string",
      NodeType = "string",
      NumberOfNodes = 123,
      Classic = TRUE|FALSE
    ),
    PauseCluster = list(
      ClusterIdentifier = "string"
    ),
    ResumeCluster = list(
      ClusterIdentifier = "string"
    )
  ),
  Schedule = "string",
  IamRole = "string",
  ScheduledActionDescription = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Enable = TRUE|FALSE
)
}
}

\keyword{internal}
