% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_modify_replication_group_shard_configuration}
\alias{elasticache_modify_replication_group_shard_configuration}
\title{Modifies a replication group's shards (node groups) by allowing you to
add shards, remove shards, or rebalance the keyspaces among exisiting
shards}
\usage{
elasticache_modify_replication_group_shard_configuration(
  ReplicationGroupId, NodeGroupCount, ApplyImmediately,
  ReshardingConfiguration, NodeGroupsToRemove, NodeGroupsToRetain)
}
\arguments{
\item{ReplicationGroupId}{[required] The name of the Redis (cluster mode enabled) cluster (replication group)
on which the shards are to be configured.}

\item{NodeGroupCount}{[required] The number of node groups (shards) that results from the modification of
the shard configuration.}

\item{ApplyImmediately}{[required] Indicates that the shard reconfiguration process begins immediately. At
present, the only permitted value for this parameter is \code{true}.

Value: true}

\item{ReshardingConfiguration}{Specifies the preferred availability zones for each node group in the
cluster. If the value of \code{NodeGroupCount} is greater than the current
number of node groups (shards), you can use this parameter to specify
the preferred availability zones of the cluster's shards. If you omit
this parameter ElastiCache selects availability zones for you.

You can specify this parameter only if the value of \code{NodeGroupCount} is
greater than the current number of node groups (shards).}

\item{NodeGroupsToRemove}{If the value of \code{NodeGroupCount} is less than the current number of node
groups (shards), then either \code{NodeGroupsToRemove} or
\code{NodeGroupsToRetain} is required. \code{NodeGroupsToRemove} is a list of
\code{NodeGroupId}s to remove from the cluster.

ElastiCache for Redis will attempt to remove all node groups listed by
\code{NodeGroupsToRemove} from the cluster.}

\item{NodeGroupsToRetain}{If the value of \code{NodeGroupCount} is less than the current number of node
groups (shards), then either \code{NodeGroupsToRemove} or
\code{NodeGroupsToRetain} is required. \code{NodeGroupsToRetain} is a list of
\code{NodeGroupId}s to retain in the cluster.

ElastiCache for Redis will attempt to remove all node groups except
those listed by \code{NodeGroupsToRetain} from the cluster.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReplicationGroup = list(
    ReplicationGroupId = "string",
    Description = "string",
    GlobalReplicationGroupInfo = list(
      GlobalReplicationGroupId = "string",
      GlobalReplicationGroupMemberRole = "string"
    ),
    Status = "string",
    PendingModifiedValues = list(
      PrimaryClusterId = "string",
      AutomaticFailoverStatus = "enabled"|"disabled",
      Resharding = list(
        SlotMigration = list(
          ProgressPercentage = 123.0
        )
      ),
      AuthTokenStatus = "SETTING"|"ROTATING",
      UserGroups = list(
        UserGroupIdsToAdd = list(
          "string"
        ),
        UserGroupIdsToRemove = list(
          "string"
        )
      )
    ),
    MemberClusters = list(
      "string"
    ),
    NodeGroups = list(
      list(
        NodeGroupId = "string",
        Status = "string",
        PrimaryEndpoint = list(
          Address = "string",
          Port = 123
        ),
        ReaderEndpoint = list(
          Address = "string",
          Port = 123
        ),
        Slots = "string",
        NodeGroupMembers = list(
          list(
            CacheClusterId = "string",
            CacheNodeId = "string",
            ReadEndpoint = list(
              Address = "string",
              Port = 123
            ),
            PreferredAvailabilityZone = "string",
            PreferredOutpostArn = "string",
            CurrentRole = "string"
          )
        )
      )
    ),
    SnapshottingClusterId = "string",
    AutomaticFailover = "enabled"|"disabled"|"enabling"|"disabling",
    MultiAZ = "enabled"|"disabled",
    ConfigurationEndpoint = list(
      Address = "string",
      Port = 123
    ),
    SnapshotRetentionLimit = 123,
    SnapshotWindow = "string",
    ClusterEnabled = TRUE|FALSE,
    CacheNodeType = "string",
    AuthTokenEnabled = TRUE|FALSE,
    AuthTokenLastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    TransitEncryptionEnabled = TRUE|FALSE,
    AtRestEncryptionEnabled = TRUE|FALSE,
    MemberClustersOutpostArns = list(
      "string"
    ),
    KmsKeyId = "string",
    ARN = "string",
    UserGroupIds = list(
      "string"
    )
  )
)
}
}
\description{
Modifies a replication group's shards (node groups) by allowing you to
add shards, remove shards, or rebalance the keyspaces among exisiting
shards.
}
\section{Request syntax}{
\preformatted{svc$modify_replication_group_shard_configuration(
  ReplicationGroupId = "string",
  NodeGroupCount = 123,
  ApplyImmediately = TRUE|FALSE,
  ReshardingConfiguration = list(
    list(
      NodeGroupId = "string",
      PreferredAvailabilityZones = list(
        "string"
      )
    )
  ),
  NodeGroupsToRemove = list(
    "string"
  ),
  NodeGroupsToRetain = list(
    "string"
  )
)
}
}

\keyword{internal}
