% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_from_snapshot}
\alias{rds_restore_db_cluster_from_snapshot}
\title{Creates a new DB cluster from a DB snapshot or DB cluster snapshot}
\usage{
rds_restore_db_cluster_from_snapshot(AvailabilityZones,
  DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
  DBSubnetGroupName, DatabaseName, OptionGroupName, VpcSecurityGroupIds,
  Tags, KmsKeyId, EnableIAMDatabaseAuthentication, BacktrackWindow,
  EnableCloudwatchLogsExports, EngineMode, ScalingConfiguration,
  DBClusterParameterGroupName, DeletionProtection, CopyTagsToSnapshot,
  Domain, DomainIAMRoleName)
}
\arguments{
\item{AvailabilityZones}{Provides the list of Availability Zones (AZs) where instances in the
restored DB cluster can be created.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the DB snapshot or DB cluster
snapshot. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{SnapshotIdentifier}{[required] The identifier for the DB snapshot or DB cluster snapshot to restore
from.

You can use either the name or the Amazon Resource Name (ARN) to specify
a DB cluster snapshot. However, you can use only the ARN to specify a DB
snapshot.

Constraints:
\itemize{
\item Must match the identifier of an existing Snapshot.
}}

\item{Engine}{[required] The database engine to use for the new DB cluster.

Default: The same as source

Constraint: Must be compatible with the engine of the source}

\item{EngineVersion}{The version of the database engine to use for the new DB cluster.

To list all of the available engine versions for \code{aurora} (for MySQL
5.6-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-mysql} (for
MySQL 5.7-compatible Aurora), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions\\\[\\\].EngineVersion"}

To list all of the available engine versions for \code{aurora-postgresql},
use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions\\\[\\\].EngineVersion"}

If you aren't using the default engine version, then you must specify
the engine version.

\strong{Aurora MySQL}

Example: \verb{5.6.10a}, \verb{5.6.mysql_aurora.1.19.2}, \verb{5.7.12},
\verb{5.7.mysql_aurora.2.04.5}

\strong{Aurora PostgreSQL}

Example: \verb{9.6.3}, \code{10.7}}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: This value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing DB subnet
group.

Example: \code{mySubnetgroup}}

\item{DatabaseName}{The database name for the restored DB cluster.}

\item{OptionGroupName}{The name of the option group to use for the restored DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster will belong to.}

\item{Tags}{The tags to be assigned to the restored DB cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from a DB snapshot or DB cluster snapshot.

The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias
name for the AWS KMS customer master key (CMK). To use a CMK in a
different AWS account, specify the key ARN or alias ARN.

When you don't specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
encrypted, then the restored DB cluster is encrypted using the AWS
KMS CMK that was used to encrypt the DB snapshot or DB cluster
snapshot.
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier}
isn't encrypted, then the restored DB cluster isn't encrypted.
}}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide.}}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Currently, Backtrack is only supported for Aurora MySQL DB clusters.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to Amazon
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineMode}{The DB engine mode of the DB cluster, either \code{provisioned},
\code{serverless}, \code{parallelquery}, \code{global}, or \code{multimaster}.

For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html}{CreateDBCluster}.}

\item{ScalingConfiguration}{For DB clusters in \code{serverless} DB engine mode, the scaling properties
of the DB cluster.}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default DB cluster parameter
group for the specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing default DB cluster
parameter group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
cluster to snapshots of the restored DB cluster. The default is not to
copy them.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB cluster in.
The domain must be created prior to this operation. Currently, only
MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be
created in an Active Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}
}
\description{
Creates a new DB cluster from a DB snapshot or DB cluster snapshot. This
action only applies to Aurora DB clusters.

The target DB cluster is created from the source snapshot with a default
configuration. If you don't specify a security group, the new DB cluster
is associated with the default security group.

This action only restores the DB cluster, not the DB instances for that
DB cluster. You must invoke the \code{CreateDBInstance} action to create DB
instances for the restored DB cluster, specifying the identifier of the
restored DB cluster in \code{DBClusterIdentifier}. You can create DB
instances only after the \code{RestoreDBClusterFromSnapshot} action has
completed and the DB cluster is available.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_from_snapshot(
  AvailabilityZones = list(
    "string"
  ),
  DBClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  DBSubnetGroupName = "string",
  DatabaseName = "string",
  OptionGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  BacktrackWindow = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  EngineMode = "string",
  ScalingConfiguration = list(
    MinCapacity = 123,
    MaxCapacity = 123,
    AutoPause = TRUE|FALSE,
    SecondsUntilAutoPause = 123,
    TimeoutAction = "string"
  ),
  DBClusterParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  CopyTagsToSnapshot = TRUE|FALSE,
  Domain = "string",
  DomainIAMRoleName = "string"
)
}
}

\keyword{internal}
