% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_copy_db_cluster_snapshot}
\alias{docdb_copy_db_cluster_snapshot}
\title{Copies a snapshot of a cluster}
\usage{
docdb_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
  TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
  Tags)
}
\arguments{
\item{SourceDBClusterSnapshotIdentifier}{[required] The identifier of the cluster snapshot to copy. This parameter is not
case sensitive.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the \emph{available} state.
\item If the source snapshot is in the same AWS Region as the copy,
specify a valid snapshot identifier.
\item If the source snapshot is in a different AWS Region than the copy,
specify a valid cluster snapshot ARN.
}

Example: \code{my-cluster-snapshot1}}

\item{TargetDBClusterSnapshotIdentifier}{[required] The identifier of the new cluster snapshot to create from the source
cluster snapshot. This parameter is not case sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-snapshot2}}

\item{KmsKeyId}{The AWS KMS key ID for an encrypted cluster snapshot. The AWS KMS key ID
is the Amazon Resource Name (ARN), AWS KMS key identifier, or the AWS
KMS key alias for the AWS KMS encryption key.

If you copy an encrypted cluster snapshot from your AWS account, you can
specify a value for \code{KmsKeyId} to encrypt the copy with a new AWS KMS
encryption key. If you don't specify a value for \code{KmsKeyId}, then the
copy of the cluster snapshot is encrypted with the same AWS KMS key as
the source cluster snapshot.

If you copy an encrypted cluster snapshot that is shared from another
AWS account, then you must specify a value for \code{KmsKeyId}.

To copy an encrypted cluster snapshot to another AWS Region, set
\code{KmsKeyId} to the AWS KMS key ID that you want to use to encrypt the
copy of the cluster snapshot in the destination Region. AWS KMS
encryption keys are specific to the AWS Region that they are created in,
and you can't use encryption keys from one AWS Region in another AWS
Region.

If you copy an unencrypted cluster snapshot and specify a value for the
\code{KmsKeyId} parameter, an error is returned.}

\item{PreSignedUrl}{The URL that contains a Signature Version 4 signed request for the
\code{CopyDBClusterSnapshot} API action in the AWS Region that contains the
source cluster snapshot to copy. You must use the \code{PreSignedUrl}
parameter when copying a cluster snapshot from another AWS Region.

If you are using an AWS SDK tool or the AWS CLI, you can specify
\code{SourceRegion} (or \code{--source-region} for the AWS CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a pre-signed URL that is a valid request for the operation
that can be executed in the source AWS Region.

The presigned URL must be a valid request for the
\code{CopyDBClusterSnapshot} API action that can be executed in the source
AWS Region that contains the cluster snapshot to be copied. The
presigned URL request must contain the following parameter values:
\itemize{
\item \code{SourceRegion} - The ID of the region that contains the snapshot to
be copied.
\item \code{SourceDBClusterSnapshotIdentifier} - The identifier for the the
encrypted cluster snapshot to be copied. This identifier must be in
the Amazon Resource Name (ARN) format for the source AWS Region. For
example, if you are copying an encrypted cluster snapshot from the
us-east-1 AWS Region, then your \code{SourceDBClusterSnapshotIdentifier}
looks something like the following:
\code{arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot}.
\item \code{TargetDBClusterSnapshotIdentifier} - The identifier for the new
cluster snapshot to be created. This parameter isn't case sensitive.
}}

\item{CopyTags}{Set to \code{true} to copy all tags from the source cluster snapshot to the
target cluster snapshot, and otherwise \code{false}. The default is \code{false}.}

\item{Tags}{The tags to be assigned to the cluster snapshot.}
}
\description{
Copies a snapshot of a cluster.

To copy a cluster snapshot from a shared manual cluster snapshot,
\code{SourceDBClusterSnapshotIdentifier} must be the Amazon Resource Name
(ARN) of the shared cluster snapshot. You can only copy a shared DB
cluster snapshot, whether encrypted or not, in the same AWS Region.

To cancel the copy operation after it is in progress, delete the target
cluster snapshot identified by \code{TargetDBClusterSnapshotIdentifier} while
that cluster snapshot is in the \emph{copying} status.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_snapshot(
  SourceDBClusterSnapshotIdentifier = "string",
  TargetDBClusterSnapshotIdentifier = "string",
  KmsKeyId = "string",
  PreSignedUrl = "string",
  CopyTags = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
