% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_tags}
\alias{redshift_describe_tags}
\title{Returns a list of tags}
\usage{
redshift_describe_tags(ResourceName, ResourceType, MaxRecords, Marker,
  TagKeys, TagValues)
}
\arguments{
\item{ResourceName}{The Amazon Resource Name (ARN) for which you want to describe the tag or
tags. For example, \code{arn:aws:redshift:us-east-1:123456789:cluster:t1}.}

\item{ResourceType}{The type of resource with which you want to view tags. Valid resource
types are:
\itemize{
\item Cluster
\item CIDR/IP
\item EC2 security group
\item Snapshot
\item Cluster security group
\item Subnet group
\item HSM connection
\item HSM certificate
\item Parameter group
\item Snapshot copy grant
}

For more information about Amazon Redshift resource types and
constructing ARNs, go to \href{http://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions}{Specifying Policy Elements: Actions, Effects, Resources, and Principals}
in the Amazon Redshift Cluster Management Guide.}

\item{MaxRecords}{The maximum number or response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned \code{marker} value.}

\item{Marker}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
marker value in the \code{marker} parameter and retrying the command. If the
\code{marker} field is empty, all response records have been retrieved for
the request.}

\item{TagKeys}{A tag key or keys for which you want to return all matching resources
that are associated with the specified key or keys. For example, suppose
that you have resources tagged with keys called \code{owner} and
\code{environment}. If you specify both of these tag keys in the request,
Amazon Redshift returns a response with all resources that have either
or both of these tag keys associated with them.}

\item{TagValues}{A tag value or values for which you want to return all matching
resources that are associated with the specified value or values. For
example, suppose that you have resources tagged with values called
\code{admin} and \code{test}. If you specify both of these tag values in the
request, Amazon Redshift returns a response with all resources that have
either or both of these tag values associated with them.}
}
\description{
Returns a list of tags. You can return tags from a specific resource by
specifying an ARN, or you can return all tags for a given type of
resource, such as clusters, snapshots, and so on.
}
\details{
The following are limitations for \code{DescribeTags}:
\itemize{
\item You cannot specify an ARN and a resource-type value together in the
same request.
\item You cannot use the \code{MaxRecords} and \code{Marker} parameters together
with the ARN parameter.
\item The \code{MaxRecords} parameter can be a range from 10 to 50 results to
return in a request.
}

If you specify both tag keys and tag values in the same request, Amazon
Redshift returns all resources that match any combination of the
specified keys and values. For example, if you have \code{owner} and
\code{environment} for tag keys, and \code{admin} and \code{test} for tag values, all
resources that have any combination of those values are returned.

If both tag keys and values are omitted from the request, resources are
returned regardless of whether they have tag keys or values associated
with them.
}
\section{Request syntax}{
\preformatted{svc$describe_tags(
  ResourceName = "string",
  ResourceType = "string",
  MaxRecords = 123,
  Marker = "string",
  TagKeys = list(
    "string"
  ),
  TagValues = list(
    "string"
  )
)
}
}

\keyword{internal}
