% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_snapshot_attributes}
\alias{rds_describe_db_snapshot_attributes}
\title{Returns a list of DB snapshot attribute names and values for a manual DB
snapshot}
\usage{
rds_describe_db_snapshot_attributes(DBSnapshotIdentifier)
}
\arguments{
\item{DBSnapshotIdentifier}{[required] The identifier for the DB snapshot to describe the attributes for.}
}
\description{
Returns a list of DB snapshot attribute names and values for a manual DB
snapshot.
}
\details{
When sharing snapshots with other AWS accounts,
\code{DescribeDBSnapshotAttributes} returns the \code{restore} attribute and a
list of IDs for the AWS accounts that are authorized to copy or restore
the manual DB snapshot. If \code{all} is included in the list of values for
the \code{restore} attribute, then the manual DB snapshot is public and can
be copied or restored by all AWS accounts.

To add or remove access for an AWS account to copy or restore a manual
DB snapshot, or to make the manual DB snapshot public or private, use
the ModifyDBSnapshotAttribute API action.
}
\section{Request syntax}{
\preformatted{svc$describe_db_snapshot_attributes(
  DBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
