% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_put_image_tag_mutability}
\alias{ecr_put_image_tag_mutability}
\title{Updates the image tag mutability settings for the specified repository}
\usage{
ecr_put_image_tag_mutability(
  registryId = NULL,
  repositoryName,
  imageTagMutability
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry that
contains the repository in which to update the image tag mutability
settings. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository in which to update the image tag mutability
settings.}

\item{imageTagMutability}{[required] The tag mutability setting for the repository. If \code{MUTABLE} is
specified, image tags can be overwritten. If \code{IMMUTABLE} is specified,
all image tags within the repository will be immutable which will
prevent them from being overwritten.}
}
\description{
Updates the image tag mutability settings for the specified repository. For more information, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html}{Image tag mutability} in the \emph{Amazon Elastic Container Registry User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ecr_put_image_tag_mutability/} for full documentation.
}
\keyword{internal}
