% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_register_image}
\alias{ec2_register_image}
\title{Registers an AMI}
\usage{
ec2_register_image(
  ImageLocation = NULL,
  BillingProducts = NULL,
  BootMode = NULL,
  TpmSupport = NULL,
  UefiData = NULL,
  ImdsSupport = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  Name,
  Description = NULL,
  Architecture = NULL,
  KernelId = NULL,
  RamdiskId = NULL,
  RootDeviceName = NULL,
  BlockDeviceMappings = NULL,
  VirtualizationType = NULL,
  SriovNetSupport = NULL,
  EnaSupport = NULL
)
}
\arguments{
\item{ImageLocation}{The full path to your AMI manifest in Amazon S3 storage. The specified
bucket must have the \code{aws-exec-read} canned access control list (ACL) to
ensure that it can be accessed by Amazon EC2. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{Canned ACLs}
in the \emph{Amazon S3 Service Developer Guide}.}

\item{BillingProducts}{The billing product codes. Your account must be authorized to specify
billing product codes.

If your account is not authorized to specify billing product codes, you
can publish AMIs that include billable software and list them on the
Amazon Web Services Marketplace. You must first register as a seller on
the Amazon Web Services Marketplace. For more information, see \href{https://docs.aws.amazon.com/marketplace/latest/userguide/user-guide-for-sellers.html}{Getting started as a seller}
and \href{https://docs.aws.amazon.com/marketplace/latest/userguide/ami-products.html}{AMI-based products}
in the \emph{Amazon Web Services Marketplace Seller Guide}.}

\item{BootMode}{The boot mode of the AMI. A value of \code{uefi-preferred} indicates that the
AMI supports both UEFI and Legacy BIOS.

The operating system contained in the AMI must be configured to support
the specified boot mode.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html}{Boot modes}
in the \emph{Amazon EC2 User Guide}.}

\item{TpmSupport}{Set to \code{v2.0} to enable Trusted Platform Module (TPM) support. For more
information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html}{NitroTPM}
in the \emph{Amazon EC2 User Guide}.}

\item{UefiData}{Base64 representation of the non-volatile UEFI variable store. To
retrieve the UEFI data, use the
\code{\link[=ec2_get_instance_uefi_data]{get_instance_uefi_data}} command. You can
inspect and modify the UEFI data by using the \href{https://github.com/awslabs/python-uefivars}{python-uefivars tool} on GitHub. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html}{UEFI Secure Boot}
in the \emph{Amazon EC2 User Guide}.}

\item{ImdsSupport}{Set to \code{v2.0} to indicate that IMDSv2 is specified in the AMI. Instances
launched from this AMI will have \code{HttpTokens} automatically set to
\code{required} so that, by default, the instance requires that IMDSv2 is
used when requesting instance metadata. In addition,
\code{HttpPutResponseHopLimit} is set to \code{2}. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration}{Configure the AMI}
in the \emph{Amazon EC2 User Guide}.

If you set the value to \code{v2.0}, make sure that your AMI software can
support IMDSv2.}

\item{TagSpecifications}{The tags to apply to the AMI.

To tag the AMI, the value for \code{ResourceType} must be \code{image}. If you
specify another value for \code{ResourceType}, the request fails.

To tag an AMI after it has been registered, see
\code{\link[=ec2_create_tags]{create_tags}}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Name}{[required] A name for your AMI.

Constraints: 3-128 alphanumeric characters, parentheses (()), square
brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-),
single quotes ('), at-signs (@), or underscores(_)}

\item{Description}{A description for your AMI.}

\item{Architecture}{The architecture of the AMI.

Default: For Amazon EBS-backed AMIs, \code{i386}. For instance store-backed
AMIs, the architecture specified in the manifest file.}

\item{KernelId}{The ID of the kernel.}

\item{RamdiskId}{The ID of the RAM disk.}

\item{RootDeviceName}{The device name of the root device volume (for example, \verb{/dev/sda1}).}

\item{BlockDeviceMappings}{The block device mapping entries.

If you specify an Amazon EBS volume using the ID of an Amazon EBS
snapshot, you can't specify the encryption state of the volume.

If you create an AMI on an Outpost, then all backing snapshots must be
on the same Outpost or in the Region of that Outpost. AMIs on an Outpost
that include local snapshots can be used to launch instances on the same
Outpost only. For more information, \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami}{Amazon EBS local snapshots on Outposts}
in the \emph{Amazon EBS User Guide}.}

\item{VirtualizationType}{The type of virtualization (\code{hvm} | \code{paravirtual}).

Default: \code{paravirtual}}

\item{SriovNetSupport}{Set to \code{simple} to enable enhanced networking with the Intel 82599
Virtual Function interface for the AMI and any instances that you launch
from the AMI.

There is no way to disable \code{sriovNetSupport} at this time.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.}

\item{EnaSupport}{Set to \code{true} to enable enhanced networking with ENA for the AMI and any
instances that you launch from the AMI.

This option is supported only for HVM AMIs. Specifying this option with
a PV AMI can make instances launched from the AMI unreachable.}
}
\description{
Registers an AMI. When you're creating an instance-store backed AMI, registering the AMI is the final step in the creation process. For more information about creating AMIs, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot}{Create an AMI from a snapshot} and \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-instance-store.html}{Create an instance-store backed AMI} in the \emph{Amazon EC2 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_register_image/} for full documentation.
}
\keyword{internal}
