% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_lock_snapshot}
\alias{ec2_lock_snapshot}
\title{Locks an Amazon EBS snapshot in either governance or compliance mode to
protect it against accidental or malicious deletions for a specific
duration}
\usage{
ec2_lock_snapshot(
  SnapshotId,
  DryRun = NULL,
  LockMode,
  CoolOffPeriod = NULL,
  LockDuration = NULL,
  ExpirationDate = NULL
)
}
\arguments{
\item{SnapshotId}{[required] The ID of the snapshot to lock.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LockMode}{[required] The mode in which to lock the snapshot. Specify one of the following:
\itemize{
\item \code{governance} - Locks the snapshot in governance mode. Snapshots
locked in governance mode can't be deleted until one of the
following conditions are met:
\itemize{
\item The lock duration expires.
\item The snapshot is unlocked by a user with the appropriate
permissions.
}

Users with the appropriate IAM permissions can unlock the snapshot,
increase or decrease the lock duration, and change the lock mode to
\code{compliance} at any time.

If you lock a snapshot in \code{governance} mode, omit \strong{CoolOffPeriod}.
\item \code{compliance} - Locks the snapshot in compliance mode. Snapshots
locked in compliance mode can't be unlocked by any user. They can be
deleted only after the lock duration expires. Users can't decrease
the lock duration or change the lock mode to \code{governance}. However,
users with appropriate IAM permissions can increase the lock
duration at any time.

If you lock a snapshot in \code{compliance} mode, you can optionally
specify \strong{CoolOffPeriod}.
}}

\item{CoolOffPeriod}{The cooling-off period during which you can unlock the snapshot or
modify the lock settings after locking the snapshot in compliance mode,
in hours. After the cooling-off period expires, you can't unlock or
delete the snapshot, decrease the lock duration, or change the lock
mode. You can increase the lock duration after the cooling-off period
expires.

The cooling-off period is optional when locking a snapshot in compliance
mode. If you are locking the snapshot in governance mode, omit this
parameter.

To lock the snapshot in compliance mode immediately without a
cooling-off period, omit this parameter.

If you are extending the lock duration for a snapshot that is locked in
compliance mode after the cooling-off period has expired, omit this
parameter. If you specify a cooling-period in a such a request, the
request fails.

Allowed values: Min 1, max 72.}

\item{LockDuration}{The period of time for which to lock the snapshot, in days. The snapshot
lock will automatically expire after this period lapses.

You must specify either this parameter or \strong{ExpirationDate}, but not
both.

Allowed values: Min: 1, max 36500}

\item{ExpirationDate}{The date and time at which the snapshot lock is to automatically expire,
in the UTC time zone (\code{YYYY-MM-DDThh:mm:ss.sssZ}).

You must specify either this parameter or \strong{LockDuration}, but not
both.}
}
\description{
Locks an Amazon EBS snapshot in either \emph{governance} or \emph{compliance} mode to protect it against accidental or malicious deletions for a specific duration. A locked snapshot can't be deleted.

See \url{https://www.paws-r-sdk.com/docs/ec2_lock_snapshot/} for full documentation.
}
\keyword{internal}
