% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_stale_security_groups}
\alias{ec2_describe_stale_security_groups}
\title{Describes the stale security group rules for security groups referenced
across a VPC peering connection, transit gateway connection, or with a
security group VPC association}
\usage{
ec2_describe_stale_security_groups(
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  VpcId
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{VpcId}{[required] The ID of the VPC.}
}
\description{
Describes the stale security group rules for security groups referenced across a VPC peering connection, transit gateway connection, or with a security group VPC association. Rules are stale when they reference a deleted security group. Rules can also be stale if they reference a security group in a peer VPC for which the VPC peering connection has been deleted, across a transit gateway where the transit gateway has been deleted (or \href{https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security}{the transit gateway security group referencing feature} has been disabled), or if a security group VPC association has been disassociated.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_stale_security_groups/} for full documentation.
}
\keyword{internal}
