% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_key_pairs}
\alias{ec2_describe_key_pairs}
\title{Describes the specified key pairs or all of your key pairs}
\usage{
ec2_describe_key_pairs(
  KeyNames = NULL,
  KeyPairIds = NULL,
  IncludePublicKey = NULL,
  DryRun = NULL,
  Filters = NULL
)
}
\arguments{
\item{KeyNames}{The key pair names.

Default: Describes all of your key pairs.}

\item{KeyPairIds}{The IDs of the key pairs.}

\item{IncludePublicKey}{If \code{true}, the public key material is included in the response.

Default: \code{false}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{key-pair-id} - The ID of the key pair.
\item \code{fingerprint} - The fingerprint of the key pair.
\item \code{key-name} - The name of the key pair.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
}}
}
\description{
Describes the specified key pairs or all of your key pairs.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_key_pairs/} for full documentation.
}
\keyword{internal}
