% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_deprovision_public_ipv_4_pool_cidr}
\alias{ec2_deprovision_public_ipv_4_pool_cidr}
\title{Deprovision a CIDR from a public IPv4 pool}
\usage{
ec2_deprovision_public_ipv_4_pool_cidr(DryRun = NULL, PoolId, Cidr)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{PoolId}{[required] The ID of the pool that you want to deprovision the CIDR from.}

\item{Cidr}{[required] The CIDR you want to deprovision from the pool. Enter the CIDR you want
to deprovision with a netmask of \verb{/32}. You must rerun this command for
each IP address in the CIDR range. If your CIDR is a \verb{/24}, you will
have to run this command to deprovision each of the 256 IP addresses in
the \verb{/24} CIDR.}
}
\description{
Deprovision a CIDR from a public IPv4 pool.

See \url{https://www.paws-r-sdk.com/docs/ec2_deprovision_public_ipv_4_pool_cidr/} for full documentation.
}
\keyword{internal}
