% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpn_connection}
\alias{ec2_create_vpn_connection}
\title{Creates a VPN connection between an existing virtual private gateway or
transit gateway and a customer gateway}
\usage{
ec2_create_vpn_connection(
  CustomerGatewayId,
  Type,
  VpnGatewayId = NULL,
  TransitGatewayId = NULL,
  DryRun = NULL,
  Options = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{CustomerGatewayId}{[required] The ID of the customer gateway.}

\item{Type}{[required] The type of VPN connection (\code{ipsec.1}).}

\item{VpnGatewayId}{The ID of the virtual private gateway. If you specify a virtual private
gateway, you cannot specify a transit gateway.}

\item{TransitGatewayId}{The ID of the transit gateway. If you specify a transit gateway, you
cannot specify a virtual private gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Options}{The options for the VPN connection.}

\item{TagSpecifications}{The tags to apply to the VPN connection.}
}
\description{
Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is \code{ipsec.1}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_vpn_connection/} for full documentation.
}
\keyword{internal}
