% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_ebs_volume_recommendations}
\alias{computeoptimizer_get_ebs_volume_recommendations}
\title{Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations}
\usage{
computeoptimizer_get_ebs_volume_recommendations(
  volumeArns = NULL,
  nextToken = NULL,
  maxResults = NULL,
  filters = NULL,
  accountIds = NULL
)
}
\arguments{
\item{volumeArns}{The Amazon Resource Name (ARN) of the volumes for which to return
recommendations.}

\item{nextToken}{The token to advance to the next page of volume recommendations.}

\item{maxResults}{The maximum number of volume recommendations to return with a single
request.

To retrieve the remaining results, make another request with the
returned \code{nextToken} value.}

\item{filters}{An array of objects to specify a filter that returns a more specific
list of volume recommendations.}

\item{accountIds}{The ID of the Amazon Web Services account for which to return volume
recommendations.

If your account is the management account of an organization, use this
parameter to specify the member account for which you want to return
volume recommendations.

Only one account ID can be specified per request.}
}
\description{
Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_get_ebs_volume_recommendations/} for full documentation.
}
\keyword{internal}
