% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_cost_estimate}
\alias{lightsail_get_cost_estimate}
\title{Retrieves information about the cost estimate for a specified resource}
\usage{
lightsail_get_cost_estimate(resourceName, startTime, endTime)
}
\arguments{
\item{resourceName}{[required] The resource name.}

\item{startTime}{[required] The cost estimate start time.

Constraints:
\itemize{
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you want to use a start time of October 1, 2018, at
8 PM UTC, specify \code{1538424000} as the start time.
}

You can convert a human-friendly time to Unix time format using a
converter like \href{https://www.epochconverter.com/}{Epoch converter}.}

\item{endTime}{[required] The cost estimate end time.

Constraints:
\itemize{
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you want to use an end time of October 1, 2018, at 9
PM UTC, specify \code{1538427600} as the end time.
}

You can convert a human-friendly time to Unix time format using a
converter like \href{https://www.epochconverter.com/}{Epoch converter}.}
}
\description{
Retrieves information about the cost estimate for a specified resource. A cost estimate will not generate for a resource that has been deleted.

See \url{https://www.paws-r-sdk.com/docs/lightsail_get_cost_estimate/} for full documentation.
}
\keyword{internal}
