% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_versions_by_function}
\alias{lambda_list_versions_by_function}
\title{Returns a list of versions, with the version-specific configuration of
each}
\usage{
lambda_list_versions_by_function(FunctionName, Marker = NULL, MaxItems = NULL)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{The maximum number of versions to return. Note that
\code{\link[=lambda_list_versions_by_function]{list_versions_by_function}} returns
a maximum of 50 items in each response, even if you set the number
higher.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html}{versions}, with the version-specific configuration of each. Lambda returns up to 50 versions per call.

See \url{https://www.paws-r-sdk.com/docs/lambda_list_versions_by_function/} for full documentation.
}
\keyword{internal}
