% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_start_resource_state_update}
\alias{imagebuilder_start_resource_state_update}
\title{Begin asynchronous resource state update for lifecycle changes to the
specified image resources}
\usage{
imagebuilder_start_resource_state_update(
  resourceArn,
  state,
  executionRole = NULL,
  includeResources = NULL,
  exclusionRules = NULL,
  updateAt = NULL,
  clientToken
)
}
\arguments{
\item{resourceArn}{[required] The ARN of the Image Builder resource that is updated. The state update
might also impact associated resources.}

\item{state}{[required] Indicates the lifecycle action to take for this request.}

\item{executionRole}{The name or Amazon Resource Name (ARN) of the IAM role that’s used to
update image state.}

\item{includeResources}{A list of image resources to update state for.}

\item{exclusionRules}{Skip action on the image resource and associated resources if specified
exclusion rules are met.}

\item{updateAt}{The timestamp that indicates when resources are updated by a lifecycle
action.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}
}
\description{
Begin asynchronous resource state update for lifecycle changes to the specified image resources.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_start_resource_state_update/} for full documentation.
}
\keyword{internal}
