% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_clusters}
\alias{eks_list_clusters}
\title{Lists the Amazon EKS clusters in your Amazon Web Services account in the
specified Amazon Web Services Region}
\usage{
eks_list_clusters(maxResults = NULL, nextToken = NULL, include = NULL)
}
\arguments{
\item{maxResults}{The maximum number of results, returned in paginated output. You receive
\code{maxResults} in a single page, along with a \code{nextToken} response
element. You can see the remaining results of the initial request by
sending another request with the returned \code{nextToken} value. This value
can be between 1 and 100. If you don't use this parameter, 100 results
and a \code{nextToken} value, if applicable, are returned.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated request, where
\code{maxResults} was used and the results exceeded the value of that
parameter. Pagination continues from the end of the previous results
that returned the \code{nextToken} value. This value is null when there are
no more results to return.

This token should be treated as an opaque identifier that is used only
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{include}{Indicates whether external clusters are included in the returned list.
Use '\code{all}' to return
\url{https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html}connected
clusters, or blank to return only Amazon EKS clusters. '\code{all}' must be
in lowercase otherwise an error occurs.}
}
\description{
Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region.

See \url{https://www.paws-r-sdk.com/docs/eks_list_clusters/} for full documentation.
}
\keyword{internal}
