% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_start_task}
\alias{ecs_start_task}
\title{Starts a new task from the specified task definition on the specified
container instance or instances}
\usage{
ecs_start_task(
  cluster = NULL,
  containerInstances,
  enableECSManagedTags = NULL,
  enableExecuteCommand = NULL,
  group = NULL,
  networkConfiguration = NULL,
  overrides = NULL,
  propagateTags = NULL,
  referenceId = NULL,
  startedBy = NULL,
  tags = NULL,
  taskDefinition
)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster where
to start your task. If you do not specify a cluster, the default cluster
is assumed.}

\item{containerInstances}{[required] The container instance IDs or full ARN entries for the container
instances where you would like to place your task. You can specify up to
10 container instances.}

\item{enableECSManagedTags}{Specifies whether to use Amazon ECS managed tags for the task. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging Your Amazon ECS Resources}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{enableExecuteCommand}{Whether or not the execute command functionality is turned on for the
task. If \code{true}, this turns on the execute command functionality on all
containers in the task.}

\item{group}{The name of the task group to associate with the task. The default value
is the family name of the task definition (for example,
family:my-family-name).}

\item{networkConfiguration}{The VPC subnet and security group configuration for tasks that receive
their own elastic network interface by using the \code{awsvpc} networking
mode.}

\item{overrides}{A list of container overrides in JSON format that specify the name of a
container in the specified task definition and the overrides it
receives. You can override the default command for a container (that's
specified in the task definition or Docker image) with a \code{command}
override. You can also override existing environment variables (that are
specified in the task definition or Docker image) on a container or add
new environment variables to it with an \code{environment} override.

A total of 8192 characters are allowed for overrides. This limit
includes the JSON formatting characters of the override structure.}

\item{propagateTags}{Specifies whether to propagate the tags from the task definition or the
service to the task. If no value is specified, the tags aren't
propagated.}

\item{referenceId}{The reference ID to use for the task.}

\item{startedBy}{An optional tag specified when a task is started. For example, if you
automatically trigger a task to run a batch process job, you could apply
a unique identifier for that job to your task with the \code{startedBy}
parameter. You can then identify which tasks belong to that job by
filtering the results of a \code{\link[=ecs_list_tasks]{list_tasks}} call with the
\code{startedBy} value. Up to 36 letters (uppercase and lowercase), numbers,
hyphens (-), and underscores (_) are allowed.

If a task is started by an Amazon ECS service, the \code{startedBy} parameter
contains the deployment ID of the service that starts it.}

\item{tags}{The metadata that you apply to the task to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}

\item{taskDefinition}{[required] The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task
definition to start. If a \code{revision} isn't specified, the latest
\code{ACTIVE} revision is used.}
}
\description{
Starts a new task from the specified task definition on the specified container instance or instances.

See \url{https://www.paws-r-sdk.com/docs/ecs_start_task/} for full documentation.
}
\keyword{internal}
