% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_ipam}
\alias{ec2_modify_ipam}
\title{Modify the configurations of an IPAM}
\usage{
ec2_modify_ipam(
  DryRun = NULL,
  IpamId,
  Description = NULL,
  AddOperatingRegions = NULL,
  RemoveOperatingRegions = NULL,
  Tier = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamId}{[required] The ID of the IPAM you want to modify.}

\item{Description}{The description of the IPAM you want to modify.}

\item{AddOperatingRegions}{Choose the operating Regions for the IPAM. Operating Regions are Amazon
Web Services Regions where the IPAM is allowed to manage IP address
CIDRs. IPAM only discovers and monitors resources in the Amazon Web
Services Regions you select as operating Regions.

For more information about operating Regions, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html}{Create an IPAM} in
the \emph{Amazon VPC IPAM User Guide}.}

\item{RemoveOperatingRegions}{The operating Regions to remove.}

\item{Tier}{IPAM is offered in a Free Tier and an Advanced Tier. For more
information about the features available in each tier and the costs
associated with the tiers, see \href{https://aws.amazon.com/vpc/pricing/}{Amazon VPC pricing \> IPAM tab}.}
}
\description{
Modify the configurations of an IPAM.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_ipam/} for full documentation.
}
\keyword{internal}
