% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_pool_cidrs}
\alias{ec2_get_ipam_pool_cidrs}
\title{Get the CIDRs provisioned to an IPAM pool}
\usage{
ec2_get_ipam_pool_cidrs(
  DryRun = NULL,
  IpamPoolId,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool you want the CIDR for.}

\item{Filters}{One or more filters for the request. For more information about
filtering, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{Filtering CLI output}.}

\item{MaxResults}{The maximum number of results to return in the request.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Get the CIDRs provisioned to an IPAM pool.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_ipam_pool_cidrs/} for full documentation.
}
\keyword{internal}
