% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_instance_types_from_instance_requirements}
\alias{ec2_get_instance_types_from_instance_requirements}
\title{Returns a list of instance types with the specified instance attributes}
\usage{
ec2_get_instance_types_from_instance_requirements(
  DryRun = NULL,
  ArchitectureTypes,
  VirtualizationTypes,
  InstanceRequirements,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ArchitectureTypes}{[required] The processor architecture type.}

\item{VirtualizationTypes}{[required] The virtualization type.}

\item{InstanceRequirements}{[required] The attributes required for the instance types.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}
}
\description{
Returns a list of instance types with the specified instance attributes. You can use the response to preview the instance types without launching instances. Note that the response does not consider capacity.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_instance_types_from_instance_requirements/} for full documentation.
}
\keyword{internal}
