% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_confirm_product_instance}
\alias{ec2_confirm_product_instance}
\title{Determines whether a product code is associated with an instance}
\usage{
ec2_confirm_product_instance(InstanceId, ProductCode, DryRun = NULL)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{ProductCode}{[required] The product code. This must be a product code that you own.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.

See \url{https://www.paws-r-sdk.com/docs/ec2_confirm_product_instance/} for full documentation.
}
\keyword{internal}
